/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.average;

import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.util.average.AveragePlotPanel;
import se.prediktera.breeze.common.util.average.AverageSpectralViewer;
import se.prediktera.breeze.common.util.average.AverageSpectrumSettingsPanel;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.swing.BreezeSplitPane;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.preview.BasicPreviewPanel;
import se.prediktera.breeze.frontend.common.view.preview.MeasurementPopup;

public class AverageSpectrumViewPanel
extends AbstractViewPanel {
    private final AverageSpectralViewer viewer;
    private final BreezeSplitPane splitPane;
    private final BasicPreviewPanel panel;
    private Measurement measurement;
    private final EntryMainPanel mainPanel;
    public boolean editingEnabled = true;

    public AverageSpectrumViewPanel(EntryMainPanel entryMainPanel, Measurement measurement, String string) {
        this(entryMainPanel, Workflow.getWorkflow(measurement), string, true);
        this.showEntry(measurement, null);
    }

    public AverageSpectrumViewPanel(EntryMainPanel entryMainPanel, Workflow workflow) {
        this(entryMainPanel, workflow, "", false);
    }

    public AverageSpectrumViewPanel(final EntryMainPanel entryMainPanel, Workflow workflow, String string, final boolean bl) {
        this.mainPanel = entryMainPanel;
        this.panel = new BasicPreviewPanel(this, workflow){
            final /* synthetic */ AverageSpectrumViewPanel this$0;
            {
                this.this$0 = averageSpectrumViewPanel;
                super(workflow);
            }

            @Override
            public List<Sample> getSampleToPaint(boolean bl2) {
                if (bl2) {
                    ArrayList<Sample> arrayList = new ArrayList<Sample>(this.getSampleAreas());
                    arrayList.addAll(this.getSampleForCurrentLevel());
                    return arrayList;
                }
                return this.getSampleAreas();
            }

            private List<Sample> getSampleAreas() {
                if (this.measurement != null) {
                    return this.measurement.sampleAreas;
                }
                return new ArrayList<Sample>();
            }

            @Override
            protected void selectSamples(List<Sample> list) {
                this.this$0.viewer.selectSamples(list);
            }

            @Override
            public void showPopup(MouseEvent mouseEvent) {
                this.showPopupInternal(mouseEvent, entryMainPanel.getFrame(), breezeContextMenu -> {
                    breezeContextMenu.addButtonCloseClick("Add measurement samples as areas", this.this$0.viewer::addMeasurementSamples);
                    breezeContextMenu.addSeparator();
                    breezeContextMenu.addButtonCloseClick("Clear selection", () -> this.setSelectedSamples(new ArrayList<Sample>()));
                    breezeContextMenu.addButtonCloseClick("Delete selected areas", () -> this.this$0.viewer.clear(this.getSelectedSamples()));
                    breezeContextMenu.addButtonCloseClick("Delete all areas", this.this$0.viewer::clear);
                    if (!bl) {
                        breezeContextMenu.addSeparator();
                        breezeContextMenu.addButtonCloseClick("Add samples to Table", () -> this.this$0.viewer.addAllSamples(entryMainPanel));
                    }
                    if (this.this$0.editingEnabled) {
                        breezeContextMenu.addButtonCloseClick("Set RGB bands", () -> this.this$0.setRgbBands());
                    }
                    breezeContextMenu.addSeparator();
                    breezeContextMenu.addButtonCloseClick("Reset zoom", this.this$0.viewer.panel::zoomAll);
                    breezeContextMenu.addButtonCloseClick("Help", this.this$0.viewer::help);
                });
            }
        };
        this.viewer = new AverageSpectralViewer(entryMainPanel, this, this.panel, bl);
        this.viewer.addPlot(AveragePlotPanel.AbstractPlot.PlotTypes.Spectrum, string);
        this.panel.getRenderer().setSelectionMode(BasicPreviewPanel.SelectionMode.Add);
        this.panel.setSpectralViewer(this.viewer);
        this.splitPane = new BreezeSplitPane();
        this.splitPane.setLeftComponent(this.panel);
        this.splitPane.setRightComponent(this.viewer);
        this.splitPane.setResizeWeight(0.6);
        this.setLayout(new BorderLayout());
        this.add(this.splitPane, "Center");
        this.setLeftSettingsPanel(this.viewer.leftSettingsPanel);
        this.setRightSettingsPanel(this.viewer.legendPanel);
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        super.addComponent(breezeMainPanel);
        this.viewer.leftSettingsPanel.addRightButtons(breezeMainPanel);
    }

    public AverageSpectralViewer getViewer() {
        return this.viewer;
    }

    @Override
    public boolean showLeftSettingsPanel() {
        return AverageSpectrumSettingsPanel.shownedDuringSession;
    }

    public void changeView(boolean bl) {
        this.splitPane.setOrientation(bl ? 1 : 0);
    }

    @Override
    public String getType() {
        return "AverageSpectrum";
    }

    public void setRgbBands() {
        RawHeader rawHeader = this.measurement.rawFileThrowIfNotExists().header();
        BreezeFrame breezeFrame = this.mainPanel.getFrame();
        BreezeOptionDialog.showDialog(breezeFrame, this.mainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Set RGB bands", "", (AbstractBreezeCustomPanel)new MeasurementPopup.RgbBandPanel(rawHeader.rgbBands(), rawHeader.bandNames()), null, breezeActionEvent -> {
            final RgbBands rgbBands = ((MeasurementPopup.RgbBandPanel)breezeActionEvent.getBreezeCustomPanel()).getRgbBands();
            BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){
                final /* synthetic */ AverageSpectrumViewPanel this$0;
                {
                    this.this$0 = averageSpectrumViewPanel;
                }

                @Override
                public void runAction() {
                    ThumbnailManager.deleteAndRemoveMeasurementImageFromCache(this.this$0.measurement);
                    RawHeader rawHeader = this.this$0.measurement.rawFile().header();
                    rawHeader.setRgbBands(rgbBands);
                    rawHeader.save();
                    this.this$0.measurement.updateThumbnail(this.getProgressManager());
                    this.this$0.showEntry(this.this$0.measurement, null);
                }
            }, "Updating image");
        });
    }

    @Override
    public void showEntry(Object object, Object object2) {
        if (object instanceof Measurement) {
            Measurement measurement;
            this.measurement = measurement = (Measurement)object;
            this.panel.showEntry(this.measurement, null, true);
            this.panel.setData(this.measurement, new ArrayList());
            if (this.viewer.showLiveSpectrum()) {
                this.viewer.liveSpectrum(null, 0, 0, this.measurement.getRootSample().getSamplePath().getAverageProfile());
            } else {
                this.viewer.resetLiveSpectrum();
            }
        }
    }
}

