/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.average;

import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.segmentation.SampleImageMask;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.BreezeProgressImpl;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.FrameReader;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;

public class FileAverageSpectrum {
    public static boolean gettingSpectrum = false;

    public static void getting(Measurement measurement, Shape shape, JPanel jPanel, OnSpectrum onSpectrum) {
        FileAverageSpectrum.getting(measurement, measurement.getRefSettings(null), shape, jPanel, onSpectrum);
    }

    public static void getting(final Measurement measurement, final RtFramePredictor.RefSettings refSettings, final Shape shape, final JPanel jPanel, final OnSpectrum onSpectrum) {
        if (gettingSpectrum) {
            return;
        }
        gettingSpectrum = true;
        BreezeProgressImpl.BreezeProgressManagerDialog breezeProgressManagerDialog = new BreezeProgressImpl.BreezeProgressManagerDialog(jPanel){

            public Object doWork() {
                return FileAverageSpectrum.done(jPanel, onSpectrum, FileAverageSpectrum.perform(this.getBreezeProgress(), measurement, refSettings, shape));
            }
        };
        breezeProgressManagerDialog.invokeLater();
    }

    private static Object done(JPanel jPanel, OnSpectrum onSpectrum, float[] fArray) {
        onSpectrum.onSpectrum(fArray);
        jPanel.removeAll();
        jPanel.revalidate();
        jPanel.repaint();
        gettingSpectrum = false;
        return null;
    }

    public static void update(final Measurement measurement, final RtFramePredictor.RefSettings refSettings, final List<Sample> list, final JPanel jPanel, final OnSpectrum onSpectrum) {
        if (gettingSpectrum) {
            return;
        }
        if (!measurement.hasData()) {
            throw new RuntimeException("Measurement has no data");
        }
        gettingSpectrum = true;
        BreezeProgressImpl.BreezeProgressManagerDialog breezeProgressManagerDialog = new BreezeProgressImpl.BreezeProgressManagerDialog(jPanel){

            public Object doWork() {
                for (Sample sample : new ArrayList(list)) {
                    float[] fArray = FileAverageSpectrum.perform(this.getBreezeProgress(), measurement, refSettings, sample.getSamplePath().getOrCreateGeneralPath());
                    sample.getSamplePath().setAverageProfile(fArray);
                }
                return FileAverageSpectrum.done(jPanel, onSpectrum, null);
            }
        };
        breezeProgressManagerDialog.invokeLater();
    }

    public static float[] perform(BreezeProgress breezeProgress, Measurement measurement, Shape shape) {
        return FileAverageSpectrum.perform(breezeProgress, measurement, measurement.getRefSettings(null), shape);
    }

    public static float[] perform(BreezeProgress breezeProgress, Measurement measurement, RtFramePredictor.RefSettings refSettings, Shape shape) {
        Object object;
        if (shape == null || measurement == null) {
            return null;
        }
        RawFile rawFile = measurement.rawFile();
        RawHeader rawHeader = rawFile.header();
        double[] dArray = new double[rawHeader.bandCount().value];
        int n = rawHeader.pixelWidth().value;
        Rectangle rectangle = shape.getBounds();
        if (rectangle.y < 0 || rectangle.x < 0 || rectangle.width == 0 || rectangle.height == 0) {
            return null;
        }
        breezeProgress.setMaximumAndReset(rectangle.height);
        RtFramePredictor rtFramePredictor = null;
        Workflow workflow = measurement.getWorkflow();
        if (measurement.hasReferences() && !refSettings.convertTo.equals((Object)RtFramePredictor.ReferenceConvertTo.None)) {
            MaxSignal maxSignal = measurement.getMetaProperties().getMaxSignal(new MaxSignal(0.0f));
            rtFramePredictor = new RtFramePredictor(breezeProgress, rawHeader.bandCount(), rawHeader.pixelWidth(), rawHeader.bandNames(), maxSignal, new RtFramePredictor.FramePoolSettings(false), workflow, refSettings);
        }
        long l = 0L;
        try {
            object = new FrameReader(rawFile.file(), rawHeader).iterator();
            try {
                SpectralReference.WhiteReference whiteReference = null;
                SpectralReference.DarkReference darkReference = null;
                if (rtFramePredictor != null && rtFramePredictor.getReferenceType().using()) {
                    whiteReference = new MeasurementFileLocation.WhiteRef().file(measurement).exists() ? new SpectralReference.WhiteReference(measurement) : new SpectralReference.EmptyWhiteReference();
                    darkReference = new MeasurementFileLocation.DarkRef().file(measurement).exists() ? new SpectralReference.DarkReference(measurement) : new SpectralReference.EmptyDarkReference();
                }
                SampleImageMask sampleImageMask = new SampleImageMask(shape, rectangle);
                int n2 = 0;
                ((FrameReader.FrameIterator)object).skip(rectangle.y);
                for (int i = 0; i < rectangle.height; ++i) {
                    RawFrame rawFrame = ((FrameReader.FrameIterator)object).next();
                    if (rawFrame != null) {
                        Frame frame = rawFrame;
                        if (rtFramePredictor != null) {
                            frame = rtFramePredictor.apply(rawFrame, 0L, whiteReference, darkReference, measurement).getReferenceOrRawFrame();
                        }
                        int n3 = 0;
                        while (n3 < rectangle.width) {
                            int n4 = rectangle.x + n3;
                            if (sampleImageMask.hasData(n2) && n4 < n && FileAverageSpectrum.hasVariance(frame, n4)) {
                                for (int j = 0; j < dArray.length; ++j) {
                                    int n5 = j;
                                    dArray[n5] = dArray[n5] + (double)frame.getFrameValue(j, n4);
                                }
                                ++l;
                            }
                            ++n3;
                            ++n2;
                        }
                    }
                    breezeProgress.incStep();
                }
            }
            finally {
                if (object != null) {
                    ((FrameReader.FrameIterator)object).close();
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            if (rtFramePredictor != null) {
                rtFramePredictor.stop();
            }
        }
        if (l > 0L) {
            object = new float[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                object[i] = (float)(dArray[i] / (double)l);
            }
            return object;
        }
        return null;
    }

    private static boolean hasVariance(Frame frame, int n) {
        float f = frame.getFrameValue(0, n);
        for (int i = 0; i < frame.rows.value; ++i) {
            float f2 = frame.getFrameValue(i, n);
            if (f2 != f) {
                return true;
            }
            f = f2;
        }
        return false;
    }

    public static interface OnSpectrum {
        public void onSpectrum(float[] var1);
    }
}

