/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.image;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import se.prediktera.breeze.common.util.image.RtObjectValues;
import se.prediktera.breeze.common.util.image.RtPixel3D;
import se.prediktera.breeze.common.util.image.RtPixelFloat;
import se.prediktera.breeze.common.util.image.RtSpatialObject;

public class RtIdentifiedObject
implements RtSpatialObject {
    protected List<RtPixel3D> pointList = new ArrayList<RtPixel3D>();
    private final int id;
    private int min;
    private int max;
    private RtObjectValues objectValues;

    public RtIdentifiedObject(int n) {
        this.id = n;
    }

    public RtIdentifiedObject(int n, int[][] nArray, int n2, int n3, int n4) {
        this.id = n;
        this.max = this.min = n2;
        this.add(nArray, n3, n4, n2);
    }

    public final RtPixel3D add(int[][] nArray, int n, int n2, int n3) {
        nArray[n2][n] = this.id;
        RtPixel3D rtPixel3D = new RtPixel3D(n, n2, n3);
        if (this.min > rtPixel3D.z) {
            this.min = rtPixel3D.z;
        }
        if (this.max < rtPixel3D.z) {
            this.max = rtPixel3D.z;
        }
        this.pointList.add(rtPixel3D);
        return rtPixel3D;
    }

    public final void add(int n, int n2) {
        this.pointList.add(new RtPixel3D(n, n2, 1));
    }

    public final void add(RtIdentifiedObject rtIdentifiedObject) {
        this.pointList.addAll(rtIdentifiedObject.pointList);
    }

    public final boolean checkAndMergeObjects(int[][] nArray, RtIdentifiedObject rtIdentifiedObject, double d) {
        if (rtIdentifiedObject.min == rtIdentifiedObject.max || (double)this.min + (double)this.max * d >= (double)rtIdentifiedObject.getMax()) {
            this.mergeObjects(nArray, rtIdentifiedObject);
            return true;
        }
        return false;
    }

    public final void mergeObjects(int[][] nArray, RtIdentifiedObject rtIdentifiedObject) {
        for (RtPixel3D rtPixel3D : rtIdentifiedObject.getPointList()) {
            nArray[rtPixel3D.y][rtPixel3D.x] = this.id;
        }
        this.add(rtIdentifiedObject);
    }

    public final void analyseObject(Set<RtObjectValues.ObjectMode> set) {
        this.objectValues = new RtObjectValues(this.pointList, set);
    }

    @Override
    public final Rectangle getBoundingBox() {
        return this.objectValues.getBoundingBox();
    }

    @Override
    public final int[][] getPath() {
        return this.objectValues.getPath();
    }

    @Override
    public final int getArea() {
        return this.pointList.size();
    }

    @Override
    public RtPixelFloat getCenterPoint() {
        return this.objectValues.centerPoint;
    }

    public final int getId() {
        return this.id;
    }

    @Override
    public final int getMax() {
        return this.max;
    }

    public final RtPixel3D getMaxPoint() {
        return this.pointList.getFirst();
    }

    public final List<RtPixel3D> getPointList() {
        return this.pointList;
    }

    public final boolean isHigher(RtIdentifiedObject rtIdentifiedObject) {
        return this.max >= rtIdentifiedObject.getMax();
    }

    @Override
    public final void forEveryPixel(RtSpatialObject.ForEveryPixelCallback forEveryPixelCallback) {
        for (RtPixel3D rtPixel3D : this.pointList) {
            forEveryPixelCallback.withPixel(rtPixel3D.x, rtPixel3D.y, rtPixel3D.z);
        }
    }

    @Override
    public final void setResolution(float f) {
        this.objectValues.resolution = f;
    }

    @Override
    public final float getResolution() {
        return this.objectValues.resolution;
    }

    @Override
    public final int getHeight() {
        return this.objectValues.boundingBox.height;
    }

    @Override
    public final int getWidth() {
        return this.objectValues.boundingBox.width;
    }

    @Override
    public final int getCircumference() {
        return this.objectValues.circumference;
    }

    @Override
    public final float getRegularity() {
        return this.objectValues.regularity;
    }

    @Override
    public final float getRoundness() {
        return this.objectValues.roundness;
    }

    @Override
    public final float getOrientation() {
        return this.objectValues.orientation;
    }

    @Override
    public final float getD1() {
        return this.objectValues.d1;
    }

    @Override
    public final float getD2() {
        return this.objectValues.d2;
    }
}

