/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.image;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import se.prediktera.breeze.common.util.image.RtMatrixInterface;
import se.prediktera.breeze.common.util.type.RtThreader;

public class RtImageProcessHelper {
    public static final byte MIN = 0;
    public static final byte MAX = 1;
    public static final byte AVERAGE = 2;
    public static final byte MEDIAN = 3;
    public static final byte DERIVATE = 4;
    public static final byte THRESHOLD = 5;
    public static final byte ERODE = 6;
    public static final byte DILATE = 7;
    public static final byte REMOVE_BORDER = 9;
    private static final int[][] kernel_maximum = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};

    public static void fillMatrix(RtMatrixInterface rtMatrixInterface) {
        int n = rtMatrixInterface.getN();
        int n2 = rtMatrixInterface.getK();
        boolean[][] blArray = new boolean[n2][n];
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (blArray[j][i] || rtMatrixInterface.getValue(i, j) != 0.0 || rtMatrixInterface.isMissing(i, j)) continue;
                arrayList.clear();
                arrayList.add(new Point(j, i));
                int n3 = 0;
                for (int k = 0; k < arrayList.size(); ++k) {
                    Point point = (Point)arrayList.get(k);
                    if (blArray[point.x][point.y]) continue;
                    blArray[point.x][point.y] = true;
                    for (int i2 = 0; i2 < kernel_maximum.length; i2 += 2) {
                        int n4 = point.x + kernel_maximum[i2][0];
                        int n5 = point.y + kernel_maximum[i2][1];
                        if (n4 >= 0 && n4 < n2 && n5 >= 0 && n5 < n && !rtMatrixInterface.isMissing(n5, n4)) {
                            if (blArray[n4][n5] || rtMatrixInterface.getValue(n5, n4) != 0.0) continue;
                            arrayList.add(new Point(n4, n5));
                            continue;
                        }
                        ++n3;
                    }
                }
                if (!((double)n3 < 50.0)) continue;
                for (Point point : arrayList) {
                    rtMatrixInterface.setValue(point.y, point.x, 1.0);
                }
            }
        }
    }

    public static RtMatrixInterface processImageAverageKernel(final RtMatrixInterface rtMatrixInterface, final RtMatrixInterface rtMatrixInterface2, final int n) {
        final int n2 = n / 2;
        final int n3 = rtMatrixInterface.getN();
        final int n4 = rtMatrixInterface.getK();
        RtThreader rtThreader = new RtThreader(){

            @Override
            protected void doOp(boolean bl, int n6, int n22) {
                for (int i = n6; i < n22; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        int n32 = 0;
                        double d = 0.0;
                        if (!rtMatrixInterface.isMissing(i, j)) {
                            for (int k = 0; k < n; ++k) {
                                for (int i2 = 0; i2 < n; ++i2) {
                                    int n42 = j + k - n2;
                                    int n5 = i + i2 - n2;
                                    if (n42 < 0 || n42 >= n4 || n5 < 0 || n5 >= n3) continue;
                                    double d2 = rtMatrixInterface.getValue(n5, n42);
                                    if (rtMatrixInterface.isMissing(n5, n42)) continue;
                                    d += d2;
                                    ++n32;
                                }
                            }
                        }
                        if (n32 > 0) {
                            rtMatrixInterface2.setValue(i, j, d / (double)n32);
                            continue;
                        }
                        rtMatrixInterface2.setValue(i, j, 0.0);
                    }
                }
            }
        };
        rtThreader.execute(n3);
        return rtMatrixInterface2;
    }

    public static RtMatrixInterface processImageMedianKernel(final RtMatrixInterface rtMatrixInterface, final RtMatrixInterface rtMatrixInterface2, final int n) {
        final int n2 = n / 2;
        final int n3 = n * n;
        final int n4 = rtMatrixInterface.getN();
        final int n5 = rtMatrixInterface.getK();
        RtThreader rtThreader = new RtThreader(){

            @Override
            protected void doOp(boolean bl, int n6, int n22) {
                double[] dArray = new double[n3];
                for (int i = n6; i < n22; ++i) {
                    for (int j = 0; j < n5; ++j) {
                        int n32 = 0;
                        if (!rtMatrixInterface.isMissing(i, j)) {
                            for (int k = 0; k < n; ++k) {
                                for (int i2 = 0; i2 < n; ++i2) {
                                    int n42 = j + k - n2;
                                    int n52 = i + i2 - n2;
                                    if (n42 < 0 || n42 >= n5 || n52 < 0 || n52 >= n4) continue;
                                    double d = rtMatrixInterface.getValue(n52, n42);
                                    if (rtMatrixInterface.isMissing(n52, n42)) continue;
                                    dArray[n32] = d;
                                    ++n32;
                                }
                            }
                        }
                        if (n32 > 0) {
                            Arrays.sort(dArray, 0, n32);
                            rtMatrixInterface2.setValue(i, j, dArray[n32 / 2]);
                            continue;
                        }
                        rtMatrixInterface2.setValue(i, j, 0.0);
                    }
                }
            }
        };
        rtThreader.execute(n4);
        return rtMatrixInterface2;
    }

    public static RtMatrixInterface processImageDerivateKernel(final RtMatrixInterface rtMatrixInterface, final RtMatrixInterface rtMatrixInterface2, final int n) {
        final int n2 = n / 2;
        final int n3 = rtMatrixInterface.getN();
        final int n4 = rtMatrixInterface.getK();
        RtThreader rtThreader = new RtThreader(){

            @Override
            protected void doOp(boolean bl, int n6, int n22) {
                for (int i = n6; i < n22; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        double d = 0.0;
                        int n32 = 0;
                        if (!rtMatrixInterface.isMissing(i, j)) {
                            double d2 = rtMatrixInterface.getValue(i, j);
                            for (int k = 0; k < n; ++k) {
                                for (int i2 = 0; i2 < n; ++i2) {
                                    int n42 = j + k - n2;
                                    int n5 = i + i2 - n2;
                                    if (n42 < 0 || n42 >= n4 || n5 < 0 || n5 >= n3) continue;
                                    double d3 = rtMatrixInterface.getValue(n5, n42);
                                    if (rtMatrixInterface.isMissing(n5, n42)) continue;
                                    d = Math.max(0.0, Math.max(d, d2 - d3));
                                    ++n32;
                                }
                            }
                        }
                        if (n32 > 0) {
                            rtMatrixInterface2.setValue(i, j, d);
                            continue;
                        }
                        rtMatrixInterface2.setValue(i, j, 0.0);
                    }
                }
            }
        };
        rtThreader.execute(n3);
        return rtMatrixInterface2;
    }

    public static RtMatrixInterface processThreshold(final RtMatrixInterface rtMatrixInterface, final RtMatrixInterface rtMatrixInterface2, final double d) {
        int n = rtMatrixInterface.getN();
        final int n2 = rtMatrixInterface.getK();
        RtThreader rtThreader = new RtThreader(){

            @Override
            protected void doOp(boolean bl, int n, int n22) {
                for (int i = n; i < n22; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        double d2 = rtMatrixInterface.getValue(i, j);
                        boolean bl2 = rtMatrixInterface.isMissing(i, j);
                        if (!bl2 && d2 > d) {
                            rtMatrixInterface2.setValue(i, j, 1.0);
                            continue;
                        }
                        rtMatrixInterface2.setValue(i, j, 0.0);
                    }
                }
            }
        };
        rtThreader.execute(n);
        return rtMatrixInterface2;
    }
}

