/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.image;

import java.util.Arrays;
import se.prediktera.breeze.common.util.image.RtMatrixInterface;

public class RtMatrixFloat
implements RtMatrixInterface {
    private final int N;
    private final int K;
    private final float[][] data;
    private final boolean[][] mask;

    public RtMatrixFloat(int n, int n2) {
        this(n, n2, new boolean[n][n2]);
    }

    public RtMatrixFloat(int n, int n2, boolean[][] blArray) {
        this.N = n;
        this.K = n2;
        this.mask = blArray;
        this.data = new float[n][n2];
    }

    public void resetMask() {
        for (int i = 0; i < this.getN(); ++i) {
            Arrays.fill(this.mask[i], true);
        }
    }

    @Override
    public final int getK() {
        return this.K;
    }

    @Override
    public final int getN() {
        return this.N;
    }

    @Override
    public boolean hasMissing() {
        return true;
    }

    @Override
    public boolean isMissing(int n, int n2) {
        return this.mask[n][n2];
    }

    @Override
    public final double getValue(int n, int n2) {
        return this.data[n][n2];
    }

    @Override
    public final void setValue(int n, int n2, double d) {
        this.data[n][n2] = (float)d;
    }

    @Override
    public void setValue(int n, int n2, double d, boolean bl) {
        this.data[n][n2] = (float)d;
        this.mask[n][n2] = bl;
    }

    @Override
    public void removeMissing(int n, int n2) {
        this.mask[n][n2] = false;
    }

    public boolean[][] getMask() {
        return this.mask;
    }
}

