/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.image;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import se.prediktera.breeze.common.realtime.segmentation.SegmentationMatrix;
import se.prediktera.breeze.common.util.IntHolder;
import se.prediktera.breeze.common.util.image.RtIdentifiedObject;
import se.prediktera.breeze.common.util.image.RtPixel3D;

public class RtObjectIdentificationHelper {
    public static boolean printmatrix = false;
    private static final int[][] cursor_maximum = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
    private static final int[][] cursor_forward = new int[][]{{-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
    private static final int[][] cursor_backwards = new int[][]{{-1, 0}, {-1, -1}, {0, -1}, {1, -1}, {1, 0}, {1, 1}, {0, 1}, {-1, 1}};

    private static void printIdMatrix(int[][] nArray, int n) {
        if (printmatrix) {
            int n2 = 0;
            for (int[] nArray2 : nArray) {
                for (int i = 0; i < nArray2.length; ++i) {
                    n2 = Math.max(n2, nArray2[i]);
                }
            }
            int n3 = String.valueOf(n2).length();
            String string = "%0" + n3 + "d";
            System.out.println("#### " + n + " ####");
            for (int[] nArray3 : nArray) {
                for (int i = 0; i < nArray3.length; ++i) {
                    if (nArray3[i] == 0) {
                        System.out.print(String.format("%" + n3 + "s", "") + ",");
                        continue;
                    }
                    System.out.print(String.format(string, nArray3[i]) + ",");
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    public static void printMatrixIfDebug(SegmentationMatrix segmentationMatrix) {
        if (printmatrix) {
            segmentationMatrix.printWithPadding();
        }
    }

    public static RtIdentifiedObjectList identifyAreas(SegmentationMatrix segmentationMatrix, int n, int n5, int n6) {
        RtObjectIdentificationHelper.printMatrixIfDebug(segmentationMatrix);
        RtObjectIdentificationHelper.calculateDistance(segmentationMatrix);
        if (n > 0) {
            segmentationMatrix.forEachForwards((n2, n3, n4) -> segmentationMatrix.setValue(n3, n4, Math.max(0, n2 - n)));
        }
        RtObjectIdentificationHelper.printMatrixIfDebug(segmentationMatrix);
        int[][] nArray = segmentationMatrix.getIdMatrix();
        RtIdentifiedObjectList rtIdentifiedObjectList = new RtIdentifiedObjectList(nArray);
        segmentationMatrix.forEachForwards((n2, n3, n4) -> {
            if (n2 > 0 && nArray[n3][n4] == 0) {
                RtIdentifiedObject rtIdentifiedObject = new RtIdentifiedObject(rtIdentifiedObjectList.size() + 1);
                ArrayDeque<RtPixel3D> arrayDeque = new ArrayDeque<RtPixel3D>();
                arrayDeque.add(rtIdentifiedObject.add(nArray, n4, n3, 1));
                while (!arrayDeque.isEmpty()) {
                    RtPixel3D rtPixel3D = (RtPixel3D)arrayDeque.poll();
                    for (int[] nArray2 : cursor_maximum) {
                        int n5 = rtPixel3D.y + nArray2[1];
                        int n6 = rtPixel3D.x + nArray2[0];
                        int n7 = segmentationMatrix.getValue(n5, n6);
                        if (n7 <= 0 || nArray[n5][n6] != 0) continue;
                        arrayDeque.add(rtIdentifiedObject.add(nArray, n6, n5, n7));
                    }
                }
                if (rtIdentifiedObject.getArea() >= n5) {
                    rtIdentifiedObjectList.add(rtIdentifiedObject);
                }
            }
        });
        rtIdentifiedObjectList.checkMaxArea(n6);
        return rtIdentifiedObjectList;
    }

    public static RtIdentifiedObjectList identifyBlobs(SegmentationMatrix segmentationMatrix, double d, int n, int n5, int n6) {
        RtObjectIdentificationHelper.printMatrixIfDebug(segmentationMatrix);
        RtObjectIdentificationHelper.calculateDistance(segmentationMatrix);
        if (n > 0) {
            segmentationMatrix.forEachForwards((n2, n3, n4) -> segmentationMatrix.setValue(n3, n4, Math.max(0, n2 - n)));
        }
        RtObjectIdentificationHelper.printMatrixIfDebug(segmentationMatrix);
        return RtObjectIdentificationHelper.identifyBlobsDistance(segmentationMatrix, d, n5, n6);
    }

    private static RtIdentifiedObjectList identifyBlobsDistance(SegmentationMatrix segmentationMatrix, double d, int n4, int n5) {
        int[][] nArray = segmentationMatrix.getIdMatrix();
        IntHolder intHolder = new IntHolder();
        RtIdentifiedObjectList rtIdentifiedObjectList = new RtIdentifiedObjectList(nArray);
        segmentationMatrix.forEachForwards((n, n2, n3) -> {
            if (n > 0) {
                boolean bl = true;
                for (int[] nArray2 : cursor_maximum) {
                    if (n >= segmentationMatrix.getValue(n2 + nArray2[1], n3 + nArray2[0])) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    if (intHolder.getValue() < n) {
                        intHolder.setValue(n);
                    }
                    rtIdentifiedObjectList.addWithHash(new RtIdentifiedObject(rtIdentifiedObjectList.size() + 1, nArray, n, n3, n2));
                }
            }
        });
        if (!rtIdentifiedObjectList.isEmpty()) {
            RtObjectIdentificationHelper.printIdMatrix(nArray, intHolder.getValue() + 1);
            LinkedList<RtPixel3D> linkedList = new LinkedList<RtPixel3D>();
            for (int i = intHolder.getValue(); i > 0; --i) {
                LinkedList<RtPixel3D> linkedList2 = new LinkedList<RtPixel3D>();
                for (RtIdentifiedObject rtIdentifiedObject : rtIdentifiedObjectList) {
                    if (rtIdentifiedObject.getMax() != i) continue;
                    linkedList.add(new RtPixel3D(rtIdentifiedObject.getMaxPoint()));
                }
                for (RtPixel3D rtPixel3D : linkedList) {
                    if (rtPixel3D.z != i) continue;
                    int n6 = nArray[rtPixel3D.y][rtPixel3D.x];
                    RtIdentifiedObject rtIdentifiedObject = rtIdentifiedObjectList.getObjectFromHash(n6);
                    for (int[] nArray2 : cursor_maximum) {
                        int n7 = rtPixel3D.y + nArray2[1];
                        int n8 = rtPixel3D.x + nArray2[0];
                        int n9 = segmentationMatrix.getValue(n7, n8);
                        if (n9 <= 0 || n9 > i || nArray[n7][n8] == n6) continue;
                        if (nArray[n7][n8] > 0) {
                            RtIdentifiedObject rtIdentifiedObject2 = rtIdentifiedObjectList.getObjectFromHash(nArray[n7][n8]);
                            if (rtIdentifiedObject.isHigher(rtIdentifiedObject2)) {
                                if (!rtIdentifiedObject.checkAndMergeObjects(nArray, rtIdentifiedObject2, d)) continue;
                                rtIdentifiedObjectList.removeWithHash(rtIdentifiedObject2);
                                continue;
                            }
                            if (!rtIdentifiedObject2.checkAndMergeObjects(nArray, rtIdentifiedObject, d)) continue;
                            rtIdentifiedObjectList.removeWithHash(rtIdentifiedObject);
                            rtIdentifiedObject = rtIdentifiedObject2;
                            n6 = rtIdentifiedObject2.getId();
                            continue;
                        }
                        linkedList2.add(rtIdentifiedObject.add(nArray, n8, n7, n9));
                    }
                }
                linkedList.clear();
                RtObjectIdentificationHelper.printIdMatrix(nArray, i);
                linkedList.addAll(linkedList2);
            }
        }
        rtIdentifiedObjectList.checkMinArea(n4);
        rtIdentifiedObjectList.checkMaxArea(n5);
        return rtIdentifiedObjectList;
    }

    public static void calculateDistance(SegmentationMatrix segmentationMatrix) {
        segmentationMatrix.forEachForwards((n, n2, n3) -> {
            if (n > 0) {
                int n4 = Integer.MAX_VALUE;
                for (int[] nArray : cursor_forward) {
                    n4 = Math.min(segmentationMatrix.getValue(n2 + nArray[1], n3 + nArray[0]), n4);
                }
                segmentationMatrix.setValue(n2, n3, n4 + 1);
            }
        });
        segmentationMatrix.forEachBackwards((n, n2, n3) -> {
            if (n > 0) {
                int n4 = Integer.MAX_VALUE;
                for (int[] nArray : cursor_backwards) {
                    n4 = Math.min(segmentationMatrix.getValue(n2 + nArray[1], n3 + nArray[0]), n4);
                }
                segmentationMatrix.setValue(n2, n3, n4 + 1);
            }
        });
    }

    public static class RtIdentifiedObjectList
    implements Iterable<RtIdentifiedObject> {
        public int[][] idMatrix;
        private final List<RtIdentifiedObject> list = new LinkedList<RtIdentifiedObject>();
        private final HashMap<Integer, RtIdentifiedObject> indexHashMap = new HashMap();

        public RtIdentifiedObjectList(int[][] nArray) {
            this.idMatrix = nArray;
        }

        public final int size() {
            return this.list.size();
        }

        public final void add(RtIdentifiedObject rtIdentifiedObject) {
            this.list.add(rtIdentifiedObject);
        }

        public final void addWithHash(RtIdentifiedObject rtIdentifiedObject) {
            this.add(rtIdentifiedObject);
            this.indexHashMap.put(rtIdentifiedObject.getId(), rtIdentifiedObject);
        }

        public final RtIdentifiedObject get(int n) {
            return this.list.get(n);
        }

        public final boolean isEmpty() {
            return this.list.isEmpty();
        }

        public final void removeWithHash(RtIdentifiedObject rtIdentifiedObject) {
            this.list.remove(rtIdentifiedObject);
            this.indexHashMap.remove(rtIdentifiedObject.getId());
        }

        public final void remove(int n) {
            this.list.remove(n);
        }

        public final RtIdentifiedObject getObjectFromHash(int n) {
            return this.indexHashMap.get(n);
        }

        public void checkMinArea(int n) {
            if (n > 0) {
                Iterator<RtIdentifiedObject> iterator = this.iterator();
                while (iterator.hasNext()) {
                    RtIdentifiedObject rtIdentifiedObject = iterator.next();
                    if (rtIdentifiedObject.getArea() >= n) continue;
                    iterator.remove();
                }
            }
        }

        public void checkMaxArea(int n) {
            if (n > 0) {
                Iterator<RtIdentifiedObject> iterator = this.iterator();
                while (iterator.hasNext()) {
                    RtIdentifiedObject rtIdentifiedObject = iterator.next();
                    if (rtIdentifiedObject.getArea() <= n) continue;
                    iterator.remove();
                }
            }
        }

        @Override
        public Iterator<RtIdentifiedObject> iterator() {
            return this.list.iterator();
        }

        @Generated
        public List<RtIdentifiedObject> getList() {
            return this.list;
        }
    }
}

