/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.image;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import se.prediktera.breeze.common.util.image.RtFollowBorder;
import se.prediktera.breeze.common.util.image.RtMatrixExtensions;
import se.prediktera.breeze.common.util.image.RtPixel3D;
import se.prediktera.breeze.common.util.image.RtPixelFloat;

public class RtObjectValues {
    private static final double CONVCRITSQ = 1.0E-12;
    private static final int NITMAX = 200;
    protected float resolution = 1.0f;
    protected Rectangle boundingBox;
    protected int circumference;
    protected float regularity;
    protected float roundness;
    protected float orientation;
    protected float d1;
    protected float d2;
    public float areadivcirc;
    public float ssx;
    protected RtPixel3D centerPixel = new RtPixel3D();
    protected RtPixelFloat centerPoint;
    protected List<RtPixel3D> borderList;

    public RtObjectValues(List<RtPixel3D> list, Set<ObjectMode> set) {
        this.calculateWidhtHeightAndCenter(list);
        if (set.contains((Object)ObjectMode.Radius)) {
            this.calculateRadiusAndRoundness(list);
        }
        if (set.contains((Object)ObjectMode.Rotation)) {
            this.rotateObjectUsingPCAandCalculateD1D2Orientation(list);
        } else {
            this.d1 = Math.max(this.boundingBox.width, this.boundingBox.height);
            this.d2 = Math.min(this.boundingBox.width, this.boundingBox.height);
            this.orientation = 0.0f;
        }
        if (set.contains((Object)ObjectMode.Border)) {
            this.borderList = RtFollowBorder.followPixelBorder(list, this.boundingBox.x, this.boundingBox.y, this.boundingBox.width, this.boundingBox.height);
            this.calculateCircumferenceAndRegularity(list);
        } else {
            this.borderList = new ArrayList<RtPixel3D>();
        }
    }

    private void calculateRadiusAndRoundness(List<RtPixel3D> list) {
        double d;
        double d2;
        double d3 = 0.0;
        for (RtPixel3D rtPixel3D : list) {
            d2 = (float)rtPixel3D.x - this.centerPoint.x;
            d = (float)rtPixel3D.y - this.centerPoint.y;
            double d4 = d2 * d2 + d * d;
            if (!(d4 > d3)) continue;
            d3 = d4;
        }
        double d5 = list.size();
        d2 = Math.sqrt(d3);
        d = Math.PI * d2 * d2;
        this.roundness = (float)(d5 / d);
        if (this.roundness > 1.0f) {
            this.roundness = 1.0f;
        }
    }

    private void calculateWidhtHeightAndCenter(List<RtPixel3D> list) {
        if (list.isEmpty()) {
            this.boundingBox = new Rectangle(0, 0, 0, 0);
            this.centerPoint = new RtPixelFloat(0.0f, 0.0f);
        } else {
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            int n3 = Integer.MAX_VALUE;
            int n4 = 0;
            int n5 = 0;
            float f = 0.0f;
            float f2 = 0.0f;
            for (RtPixel3D rtPixel3D : list) {
                if (rtPixel3D.x < n) {
                    n = rtPixel3D.x;
                }
                if (rtPixel3D.x > n2) {
                    n2 = rtPixel3D.x;
                }
                if (rtPixel3D.y < n3) {
                    n3 = rtPixel3D.y;
                }
                if (rtPixel3D.y > n4) {
                    n4 = rtPixel3D.y;
                }
                if (rtPixel3D.z > n5) {
                    n5 = rtPixel3D.z;
                    this.centerPixel.x = rtPixel3D.x;
                    this.centerPixel.y = rtPixel3D.y;
                }
                f2 = (float)((double)f2 + ((double)rtPixel3D.x + 0.5));
                f = (float)((double)f + ((double)rtPixel3D.y + 0.5));
            }
            this.boundingBox = new Rectangle(n, n3, n2 - n + 1, n4 - n3 + 1);
            this.centerPoint = new RtPixelFloat(f2 / (float)list.size(), f / (float)list.size());
        }
    }

    private void calculateCircumferenceAndRegularity(List<RtPixel3D> list) {
        if (this.borderList != null) {
            this.circumference = 0;
            for (int i = 1; i < this.borderList.size(); ++i) {
                RtPixel3D rtPixel3D = this.borderList.get(i - 1);
                RtPixel3D rtPixel3D2 = this.borderList.get(i);
                this.circumference += Math.abs(rtPixel3D.x - rtPixel3D2.x) + Math.abs(rtPixel3D.y - rtPixel3D2.y);
            }
            double d = list.size();
            double d2 = Math.sqrt(d / Math.PI);
            double d3 = Math.PI * 2 * d2;
            this.regularity = (float)(d3 / (double)this.circumference);
            if (this.circumference > 0) {
                this.areadivcirc = (float)d / (float)this.circumference;
            }
        }
    }

    private void rotateObjectUsingPCAandCalculateD1D2Orientation(List<RtPixel3D> list) {
        double d;
        double d2;
        double d3;
        RtPixel3D rtPixel3D2;
        DenseMatrix denseMatrix = new DenseMatrix(list.size(), 2);
        int n = 0;
        for (RtPixel3D rtPixel3D2 : list) {
            d3 = (float)rtPixel3D2.x - this.centerPoint.x;
            d2 = (float)rtPixel3D2.y - this.centerPoint.y;
            denseMatrix.set(n, 0, d3);
            denseMatrix.set(n, 1, d2);
            ++n;
        }
        DenseVector[][] denseVectorArray = this.createPCA(denseMatrix, 1);
        rtPixel3D2 = denseVectorArray[1][0];
        d3 = rtPixel3D2.get(0);
        d2 = rtPixel3D2.get(1);
        if (d3 < 0.0) {
            d3 *= -1.0;
            d2 *= -1.0;
        }
        if (d2 < 0.0) {
            d3 *= -1.0;
            d2 *= -1.0;
        }
        if ((d = Math.acos(d3 *= -1.0)) >= 0.0) {
            this.orientation = (float)(d / Math.PI * 180.0);
            if (this.orientation >= 180.0f) {
                this.orientation -= 180.0f;
            }
            if (this.orientation < 0.0f) {
                this.orientation += 180.0f;
            }
        } else {
            this.orientation = 0.0f;
        }
        double d4 = 2.147483647E9;
        double d5 = 0.0;
        double d6 = 2.147483647E9;
        double d7 = 0.0;
        double d8 = Math.cos(d);
        double d9 = Math.sin(d);
        for (RtPixel3D rtPixel3D3 : list) {
            double d10 = (float)rtPixel3D3.x - this.centerPoint.x;
            double d11 = (float)rtPixel3D3.y - this.centerPoint.y;
            double d12 = d10 * d8 - d11 * d9;
            double d13 = d11 * d8 + d10 * d9;
            if (d12 < d4) {
                d4 = d12;
            }
            if (d12 > d5) {
                d5 = d12;
            }
            if (d13 < d6) {
                d6 = d13;
            }
            if (!(d13 > d7)) continue;
            d7 = d13;
        }
        this.d1 = (float)(d5 - d4);
        if (this.d1 < 0.0f) {
            this.d1 = 0.0f;
        }
        this.d2 = (float)(d7 - d6);
        if (this.d2 < 0.0f) {
            this.d2 = 0.0f;
        }
    }

    private DenseVector[][] createPCA(DenseMatrix denseMatrix, int n) {
        double d = 0.0;
        for (int i = 0; i < denseMatrix.numRows(); ++i) {
            for (int j = 0; j < denseMatrix.numColumns(); ++j) {
                double d2 = denseMatrix.get(i, j);
                d += d2 * d2;
            }
        }
        DenseVector[] denseVectorArray = new DenseVector[n];
        DenseVector[] denseVectorArray2 = new DenseVector[n];
        for (int i = 0; i < n; ++i) {
            double d3;
            double d4;
            int n2 = denseMatrix.numRows();
            DenseVector denseVector = denseVectorArray[i] = new DenseVector(n2);
            for (int j = 0; j < n2; ++j) {
                denseVector.set(j, (denseMatrix.get(j, 0) + denseMatrix.get(j, 1)) / 2.0);
            }
            DenseVector denseVector2 = new DenseVector(n2);
            DenseVector denseVector3 = null;
            DenseVector denseVector4 = denseVectorArray2[i] = new DenseVector(denseMatrix.numColumns());
            int n3 = 0;
            for (double d5 = 42.0; n3 < 200 && d5 > 1.0E-12; d5 /= d4, ++n3) {
                denseVector3 = denseVector2;
                denseVector2 = denseVector;
                denseVector = denseVector3;
                RtMatrixExtensions.transMult(denseVector4, (Matrix)denseMatrix, denseVector2);
                denseVector4.scale(1.0 / denseVector4.norm(Vector.Norm.Two));
                RtMatrixExtensions.mult(denseVector, (Matrix)denseMatrix, denseVector4);
                d5 = 0.0;
                double[] dArray = denseVector2.getData();
                double[] dArray2 = denseVector.getData();
                d4 = 0.0;
                d3 = 0.0;
                for (int j = 0; j < n2; ++j) {
                    d3 = dArray2[j];
                    d4 += d3 * d3;
                    d5 += (d3 -= dArray[j]) * d3;
                }
            }
            double d6 = 0.0;
            for (int j = 0; j < denseMatrix.numRows(); ++j) {
                for (int k = 0; k < denseMatrix.numColumns(); ++k) {
                    denseMatrix.set(j, k, denseMatrix.get(j, k) - denseVector.get(j) * denseVector4.get(k));
                    d3 = denseMatrix.get(j, k);
                    d6 += d3 * d3;
                }
            }
            this.ssx = d == 0.0 ? 1.0f : (float)((d - d6) / d);
        }
        return new DenseVector[][]{denseVectorArray, denseVectorArray2};
    }

    public int[][] getPath() {
        int[][] nArray = new int[this.borderList.size()][2];
        for (int i = 0; i < this.borderList.size(); ++i) {
            nArray[i][0] = this.borderList.get((int)i).x + this.boundingBox.x;
            nArray[i][1] = this.borderList.get((int)i).y + this.boundingBox.y;
        }
        return nArray;
    }

    public Rectangle getBoundingBox() {
        return this.boundingBox;
    }

    public static enum ObjectMode {
        Radius,
        Rotation,
        Border;


        public static Set<ObjectMode> all() {
            return ObjectMode.create(Radius, Rotation, Border);
        }

        public static Set<ObjectMode> create(ObjectMode ... objectModeArray) {
            HashSet<ObjectMode> hashSet = new HashSet<ObjectMode>();
            Collections.addAll(hashSet, objectModeArray);
            return hashSet;
        }
    }
}

