/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import se.prediktera.breeze.common.util.image.RtPixelFloat;

public interface RtSpatialObject {
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");

    public int[][] getPath();

    public RtPixelFloat getCenterPoint();

    public Rectangle getBoundingBox();

    public void setResolution(float var1);

    public float getResolution();

    public int getArea();

    public int getHeight();

    public int getWidth();

    public int getCircumference();

    public float getRegularity();

    public float getRoundness();

    public float getOrientation();

    public float getD1();

    public float getD2();

    public int getMax();

    public void forEveryPixel(ForEveryPixelCallback var1);

    public static void saveImageWithTimestamp(RtSpatialObject rtSpatialObject, File file, String string) {
        RtSpatialObject.saveImage(rtSpatialObject, new File(file, string + "_" + sdf.format(new Date()) + ".png"));
    }

    public static void saveImage(RtSpatialObject rtSpatialObject, File file) {
        try {
            ImageIO.write((RenderedImage)RtSpatialObject.createImage(rtSpatialObject), "png", file);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static BufferedImage createImage(RtSpatialObject rtSpatialObject) {
        Rectangle rectangle = rtSpatialObject.getBoundingBox();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics2D.setColor(Color.black);
        rtSpatialObject.forEveryPixel((n, n2, n3) -> graphics2D.fillRect(n - rectangle.x, n2 - rectangle.y, 1, 1));
        graphics2D.dispose();
        return bufferedImage;
    }

    public static interface ForEveryPixelCallback {
        public void withPixel(int var1, int var2, int var3);
    }
}

