/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.measure;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.map.common.error.Logg;

public class ReferenceFile {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private final File file;
    private final String fileName;
    private final String fileExt;
    private final RuntimeReference type;
    private final Date date;

    public ReferenceFile(File file) {
        this.file = file;
        try {
            this.fileName = FileHelper.getFileName(file);
            this.fileExt = FileHelper.getFileExtension(file);
            String[] stringArray = this.fileName.split("_");
            this.date = ReferenceFile.parseDate(stringArray[0] + "_" + stringArray[1]);
            this.type = this.parseType(file.getParentFile().getName());
        }
        catch (Exception exception) {
            throw new NoReferenceFileException(exception);
        }
    }

    public ReferenceFile(File file, Date date, String string) {
        this.date = date;
        this.fileName = sdf.format(date);
        this.fileExt = "raw";
        this.file = new File(file, this.fileName + "." + this.fileExt);
        this.type = this.parseType(string);
    }

    private static Date parseDate(String string) {
        try {
            return sdf.parse(string);
        }
        catch (Exception exception) {
            Logg.error((String)("Cannot parse date: " + string), (Object[])new Object[0]);
            return new Date();
        }
    }

    private RuntimeReference parseType(String string) {
        for (RuntimeReference runtimeReference : RuntimeReference.values()) {
            if (!string.equalsIgnoreCase(runtimeReference.name())) continue;
            return runtimeReference;
        }
        throw new NoReferenceFileException("No valid reference file name");
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileExt() {
        return this.fileExt;
    }

    public Date getDate() {
        return this.date;
    }

    public boolean fileNameContains(String string) {
        return this.fileName.contains(string);
    }

    public RuntimeReference getType() {
        return this.type;
    }

    public static boolean isReferenceFile(File file) {
        try {
            new ReferenceFile(file);
            return true;
        }
        catch (NoReferenceFileException noReferenceFileException) {
            return false;
        }
    }

    public static ReferenceFiles getLastDarkAndWhiteReferencesFromWorkspace(File file) {
        return new ReferenceFiles(ReferenceFile.getReferencesFolder(file));
    }

    private static File getReferencesFolder(File file) {
        return new File(file, "Data/Runtime/References");
    }

    public static ReferenceFile getLastReferenceFile(File file, RuntimeReference runtimeReference) {
        List<ReferenceFile> list = ReferenceFile.getReferenceFiles(ReferenceFile.getReferenceFolder(file, runtimeReference));
        if (list.isEmpty()) {
            return null;
        }
        return list.getFirst();
    }

    private static File getReferenceFolder(File file, RuntimeReference runtimeReference) {
        return new File(file, runtimeReference.name());
    }

    public static List<ReferenceFile> getReferenceFilesFromWorkspace(File file, RuntimeReference runtimeReference) {
        return ReferenceFile.getReferenceFiles(ReferenceFile.getReferenceFolder(ReferenceFile.getReferencesFolder(file), runtimeReference));
    }

    private static List<ReferenceFile> getReferenceFiles(File file) {
        ArrayList<ReferenceFile> arrayList = new ArrayList<ReferenceFile>();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            Arrays.sort(fileArray, Comparator.comparing(File::lastModified).reversed());
            for (File file2 : fileArray) {
                ReferenceFile referenceFile;
                if (!file2.isFile() || !(referenceFile = new ReferenceFile(file2)).getFileExt().equalsIgnoreCase("raw")) continue;
                arrayList.add(referenceFile);
            }
        }
        return arrayList;
    }

    public static enum RuntimeReference {
        Dark,
        White,
        WhiteIntensity;


        public boolean isDark() {
            return this.equals((Object)Dark);
        }
    }

    public static class NoReferenceFileException
    extends RuntimeException {
        public NoReferenceFileException(Exception exception) {
            super(exception);
        }

        public NoReferenceFileException(String string) {
            super(string);
        }
    }

    public static class ReferenceFiles {
        public final ReferenceFile dark;
        public final ReferenceFile white;
        public final ReferenceFile whiteintensity;

        public ReferenceFiles(File file) {
            this.dark = ReferenceFile.getLastReferenceFile(file, RuntimeReference.Dark);
            this.white = ReferenceFile.getLastReferenceFile(file, RuntimeReference.White);
            this.whiteintensity = ReferenceFile.getLastReferenceFile(file, RuntimeReference.WhiteIntensity);
        }
    }
}

