/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.measure;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.measure.SpectralReferenceQuality;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;

public class ReferenceStatus {
    private final boolean isWhiteReference;
    private final SpectralReferenceQuality.ReferenceState state;
    private final String type;
    private final String message;
    private final double stderrLines;
    private final double stderrPixels;
    private final double min;
    private final double max;
    private final double median;
    private final double mean;
    private final double stdError;
    private final int saturatedPixels;
    private final int totalSaturated;
    private final Map<String, String> fieldMap;

    public ReferenceStatus(Map<String, String> map, boolean bl) {
        this.fieldMap = map;
        this.isWhiteReference = bl;
        this.state = SpectralReferenceQuality.ReferenceState.parse(this.get("State"));
        this.type = this.get("Type");
        this.message = this.get("Message");
        this.stderrLines = RtDataFormat.toNumber(this.get("StderrLines"));
        this.stderrPixels = RtDataFormat.toNumber(this.get("StderrPixels"));
        this.saturatedPixels = RtDataFormat.toNumberInt(this.get("SaturatedPixels"));
        this.totalSaturated = RtDataFormat.toNumberInt(this.get("TotalSaturated"));
        this.min = RtDataFormat.toNumber(this.get("Min"));
        this.max = RtDataFormat.toNumber(this.get("Max"));
        this.median = RtDataFormat.toNumber(this.get("Median"));
        this.mean = RtDataFormat.toNumber(this.get("Mean"));
        this.stdError = RtDataFormat.toNumber(this.get("StdError"));
    }

    public ReferenceStatus(SpectralReferenceQuality.ReferenceState referenceState, boolean bl) {
        this.state = referenceState;
        this.isWhiteReference = bl;
        this.type = "";
        this.message = "";
        this.stderrLines = 0.0;
        this.stderrPixels = 0.0;
        this.saturatedPixels = 0;
        this.totalSaturated = 0;
        this.min = 0.0;
        this.max = 0.0;
        this.median = 0.0;
        this.mean = 0.0;
        this.stdError = 0.0;
        this.fieldMap = new HashMap<String, String>();
    }

    private String get(String string) {
        if (this.fieldMap.containsKey(string)) {
            return this.fieldMap.get(string);
        }
        return this.fieldMap.get(string.toLowerCase());
    }

    public boolean showErrorDialog() {
        return BreezeProperties.getInstance().verifyReferenceQuality() && (this.state == SpectralReferenceQuality.ReferenceState.Error || this.saturatedPixels > 0 || this.totalSaturated > 0);
    }

    public static ReferenceStatus parse(String string, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null && !string.isEmpty()) {
            for (String string2 : string.split(";")) {
                String[] stringArray = string2.split("=", 2);
                if (stringArray.length != 2) continue;
                hashMap.put(stringArray[0].trim(), stringArray[1].trim());
            }
        }
        return new ReferenceStatus(hashMap, bl);
    }

    @Generated
    public boolean isWhiteReference() {
        return this.isWhiteReference;
    }

    @Generated
    public SpectralReferenceQuality.ReferenceState getState() {
        return this.state;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public double getStderrLines() {
        return this.stderrLines;
    }

    @Generated
    public double getStderrPixels() {
        return this.stderrPixels;
    }

    @Generated
    public double getMin() {
        return this.min;
    }

    @Generated
    public double getMax() {
        return this.max;
    }

    @Generated
    public double getMedian() {
        return this.median;
    }

    @Generated
    public double getMean() {
        return this.mean;
    }

    @Generated
    public double getStdError() {
        return this.stdError;
    }

    @Generated
    public int getSaturatedPixels() {
        return this.saturatedPixels;
    }

    @Generated
    public int getTotalSaturated() {
        return this.totalSaturated;
    }

    @Generated
    public Map<String, String> getFieldMap() {
        return this.fieldMap;
    }
}

