/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.measure;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluateResult;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.mat.FloatMatrixArrayFromFrames;
import se.prediktera.breeze.common.util.measure.ReferenceStatus;
import se.prediktera.breeze.common.util.measure.SpectralReferenceHelper;
import se.prediktera.breeze.common.util.measure.SpectralReferenceQuality;
import se.prediktera.breeze.common.util.raw.CachedRawFile;
import se.prediktera.breeze.common.util.raw.FloatMatrixArrayFromRaw;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.raw.RtReferenceTarget;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.hardware.Camera;

public abstract class SpectralReference
implements RawFile {
    private final CachedSpectralRawFile rawFile;
    private FloatMatrix[] cachedMatrix;

    public SpectralReference(CachedSpectralRawFile cachedSpectralRawFile) {
        this.rawFile = cachedSpectralRawFile;
    }

    public boolean isCompressed() {
        return FileHelper.exists(this.thumbNailFile()) && this.header().frameCount().value == 1;
    }

    @Override
    public RawHeader header() {
        return this.rawFile.header();
    }

    @Override
    public ByteBuffer readRawHeader() {
        return this.rawFile.readRawHeader();
    }

    @Override
    public List<RawFrame> readFrames() {
        return this.rawFile.readFrames();
    }

    public RawFile rawFile() {
        return this.rawFile;
    }

    public abstract ReferenceType getReferenceType();

    @Override
    public File file() {
        return this.rawFile.file();
    }

    public boolean fileExists() {
        return FileHelper.exists(this.rawFile);
    }

    public File thumbNailFile() {
        if (!this.fileExists()) {
            return FileHelper.newNonExistingFile();
        }
        return new File(this.file().getParentFile(), FilenameUtils.removeExtension((String)this.file().getName()) + ".png");
    }

    public IntegrationTime getIntegrationTime() {
        RawHeader.DescriptionData descriptionData = this.header().getDescriptionData();
        if (descriptionData != null) {
            return descriptionData.integrationTime;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FloatMatrix[] getMatrix() {
        SpectralReference spectralReference = this;
        synchronized (spectralReference) {
            if (this.cachedMatrix == null) {
                this.cachedMatrix = RawFile.hasFrames(this.rawFile) ? new FloatMatrixArrayFromFrames(this.readFrames()).array() : new FloatMatrixArrayFromRaw(this.file(), this.header()).getFrames();
            }
        }
        return this.cachedMatrix;
    }

    public abstract int reflectance();

    public abstract MeasurementFileLocation getFileLocation();

    public FrameListFromRaw.Reduce getReduce() {
        return this.rawFile.getReduce();
    }

    public void saveToDisk(Measurement measurement, Rectangle rectangle) {
        this.rawFile.write(measurement, "reference", rectangle);
    }

    public void saveToDisk(File file) {
        file.getParentFile().mkdirs();
        this.rawFile.write(file, "reference", null);
    }

    public ByteBuffer readMeasurementRawHeader() {
        return this.rawFile.readMeasurementRawHeader();
    }

    public ReferenceStatus getStatus() {
        RawHeader.DescriptionData descriptionData = this.header().getDescriptionData();
        if (descriptionData != null) {
            return descriptionData.getReferenceStatus(this.getReferenceType().isWhite());
        }
        return new ReferenceStatus(SpectralReferenceQuality.ReferenceState.Good, this.getReferenceType().isWhite());
    }

    public static void addWarnings(SpectralReference spectralReference, List<EvaluateResult> list) {
        ReferenceStatus referenceStatus;
        if (spectralReference != null && (referenceStatus = spectralReference.getStatus()).getSaturatedPixels() > 0) {
            list.add(new EvaluateResult("EM0005", "White reference has " + referenceStatus.getSaturatedPixels() + " saturated pixels"));
        }
    }

    public Date getDate() {
        return SpectralReference.getReferenceDate(this.rawFile);
    }

    public static Date getReferenceDate(RawFile rawFile) {
        Date date;
        if (!FileHelper.exists(rawFile)) {
            return new Date();
        }
        RawHeader.DescriptionData descriptionData = rawFile.header().getDescriptionData();
        if (descriptionData != null && (date = descriptionData.getDate()) != null) {
            return date;
        }
        return SpectralReferenceHelper.getReferenceFileTimeStamp(rawFile.file());
    }

    public static class CachedSpectralRawFile
    extends CachedRawFile {
        public static final int MaxFrames = 200;

        public CachedSpectralRawFile(Measurement measurement, MeasurementFileLocation measurementFileLocation) throws FileNotFoundException {
            super(measurement, measurementFileLocation);
        }

        public CachedSpectralRawFile(List<RawFrame> list, RawHeader rawHeader, MeasurementFileLocation measurementFileLocation) {
            super(list, rawHeader, measurementFileLocation);
        }

        public CachedSpectralRawFile(Measurement measurement, MeasurementFileLocation measurementFileLocation, FrameListFromRaw.Reduce reduce) throws FileNotFoundException {
            super(measurement, measurementFileLocation, reduce);
        }

        public CachedSpectralRawFile(File file) {
            super(file);
        }

        @Override
        protected FrameListFromRaw.Reduce getDefaultReduce() {
            RawHeader rawHeader = this.header();
            int n = Math.max(1, rawHeader.frameCount().value / 200);
            return new FrameListFromRaw.Reduce(1, n);
        }
    }

    public static enum ReferenceType {
        White,
        Dark;


        public boolean isWhite() {
            return this == White;
        }
    }

    public static class EmptyDarkReference
    extends DarkReference {
        public EmptyDarkReference() {
            super(new ArrayList<RawFrame>());
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    public static class DarkReference
    extends SpectralReference {
        public DarkReference(Measurement measurement, FrameListFromRaw.Reduce reduce) throws FileNotFoundException {
            super(new CachedSpectralRawFile(measurement, new MeasurementFileLocation.DarkRef(), reduce));
        }

        public DarkReference(Measurement measurement) throws FileNotFoundException {
            super(new CachedSpectralRawFile(measurement, new MeasurementFileLocation.DarkRef()));
        }

        public DarkReference(Camera camera, List<RawFrame> list) {
            super(new CachedSpectralRawFile(list, new RawHeader(camera), new MeasurementFileLocation.DarkRef()));
        }

        public DarkReference(List<RawFrame> list) {
            this(list, new RawHeader());
        }

        public DarkReference(List<RawFrame> list, RawHeader rawHeader) {
            super(new CachedSpectralRawFile(list, rawHeader, new MeasurementFileLocation.DarkRef()));
        }

        public DarkReference(File file) {
            super(new CachedSpectralRawFile(file));
        }

        @Override
        public ReferenceType getReferenceType() {
            return ReferenceType.Dark;
        }

        @Override
        public int reflectance() {
            return 0;
        }

        @Override
        public MeasurementFileLocation getFileLocation() {
            return new MeasurementFileLocation.DarkRef();
        }
    }

    public static class EmptyWhiteReference
    extends WhiteReference {
        public EmptyWhiteReference() {
            super(new ArrayList<RawFrame>());
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    public static class WhiteReference
    extends SpectralReference {
        public WhiteReference(Measurement measurement, FrameListFromRaw.Reduce reduce) throws FileNotFoundException {
            super(new CachedSpectralRawFile(measurement, new MeasurementFileLocation.WhiteRef(), reduce));
        }

        public WhiteReference(Measurement measurement) throws FileNotFoundException {
            super(new CachedSpectralRawFile(measurement, new MeasurementFileLocation.WhiteRef()));
        }

        public WhiteReference(Camera camera, List<RawFrame> list) {
            super(new CachedSpectralRawFile(list, new RawHeader(camera), new MeasurementFileLocation.WhiteRef()));
            if (camera instanceof Camera.WhiteReferenceIntensity) {
                this.header().setReferenceTarget(((Camera.WhiteReferenceIntensity)camera).getReferenceTarget());
            }
        }

        public WhiteReference(List<RawFrame> list) {
            super(new CachedSpectralRawFile(list, new RawHeader(), new MeasurementFileLocation.WhiteRef()));
        }

        public WhiteReference(List<RawFrame> list, RawHeader rawHeader) {
            super(new CachedSpectralRawFile(list, rawHeader, new MeasurementFileLocation.WhiteRef()));
        }

        public WhiteReference(File file) {
            super(new CachedSpectralRawFile(file));
        }

        @Override
        public ReferenceType getReferenceType() {
            return ReferenceType.White;
        }

        @Override
        public int reflectance() {
            return 100;
        }

        public RtReferenceTarget getReferenceTarget() {
            return this.header().getReferenceTarget();
        }

        @Override
        public MeasurementFileLocation getFileLocation() {
            return new MeasurementFileLocation.WhiteRef();
        }
    }
}

