/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.measure;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.measure.ReferenceFile;
import se.prediktera.breeze.common.util.raw.RawFile;

public class SpectralReferenceHelper {
    public static File getDarkReferenceFile(RawFile rawFile) {
        return SpectralReferenceHelper.getDarkReferenceFile(rawFile.file());
    }

    public static File getDarkReferenceFile(File file) {
        return SpectralReferenceHelper.getReferenceFile(file, ReferenceFile.RuntimeReference.Dark);
    }

    public static File getWhiteReferenceFile(RawFile rawFile) {
        return SpectralReferenceHelper.getWhiteReferenceFile(rawFile.file());
    }

    public static File getWhiteReferenceFile(File file) {
        return SpectralReferenceHelper.getReferenceFile(file, ReferenceFile.RuntimeReference.White);
    }

    public static File getReferenceFile(File file, ReferenceFile.RuntimeReference runtimeReference) {
        Pattern[] patternArray;
        Pattern[] patternArray2;
        File file2 = file.getParentFile();
        String string = FileHelper.getFileName(file);
        String string2 = FileHelper.getExtension((File)file);
        String[] stringArray = new String[]{string2, "img", "raw"};
        if (runtimeReference.isDark()) {
            Pattern[] patternArray3 = new Pattern[4];
            patternArray3[0] = new Pattern("", "", "drw");
            patternArray3[1] = new Pattern("darkref_", "", null);
            patternArray3[2] = new Pattern("", "_darkref", null);
            patternArray2 = patternArray3;
            patternArray3[3] = new Pattern("", "_dark", null);
        } else {
            Pattern[] patternArray4 = new Pattern[4];
            patternArray4[0] = new Pattern("", "", "wrw");
            patternArray4[1] = new Pattern("whiteref_", "", null);
            patternArray4[2] = new Pattern("", "_whiteref", null);
            patternArray2 = patternArray4;
            patternArray4[3] = new Pattern("", "_white", null);
        }
        for (Pattern pattern : patternArray = patternArray2) {
            if (pattern.fixedExt != null) {
                Path path = Paths.get(file2.getAbsolutePath(), pattern.prefix + string + pattern.suffix + "." + pattern.fixedExt);
                if (!Files.exists(path, new LinkOption[0])) continue;
                return path.toFile();
            }
            for (String string3 : stringArray) {
                Path path = Paths.get(file2.getAbsolutePath(), pattern.prefix + string + pattern.suffix + "." + string3);
                if (!Files.exists(path, new LinkOption[0])) continue;
                return path.toFile();
            }
        }
        if (runtimeReference.equals((Object)ReferenceFile.RuntimeReference.Dark)) {
            return new File(file2, "darkref_" + string + ".raw");
        }
        return new File(file2, "whiteref_" + string + ".raw");
    }

    public static Date getReferenceFileTimeStamp(File file) {
        String string = file.getName();
        try {
            String string2 = string.substring(0, 15);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.ROOT);
            Date date = simpleDateFormat.parse(string2);
            if (string.charAt(string.length() - 6) == '_') {
                char c = string.charAt(string.length() - 5);
                int n = c - 48;
                date = new Date(date.getTime() + (long)n);
            }
            return date;
        }
        catch (Exception exception) {
            return FileHelper.getCreationDate(file);
        }
    }

    private static class Pattern {
        final String prefix;
        final String suffix;
        final String fixedExt;

        Pattern(String string, String string2, String string3) {
            this.prefix = string;
            this.suffix = string2;
            this.fixedExt = string3;
        }
    }
}

