/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.measure;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import se.prediktera.breeze.common.util.measure.ReferenceFile;
import se.prediktera.breeze.common.util.measure.SpectralReferenceHelper;

public class SpectralReferenceHelperTest {
    private Path tempDir;

    @Before
    public void setUp() throws IOException {
        this.tempDir = Files.createTempDirectory("RefFind_", new FileAttribute[0]);
    }

    @After
    public void tearDown() {
        try {
            if (this.tempDir != null && Files.exists(this.tempDir, new LinkOption[0])) {
                Files.walk(this.tempDir, new FileVisitOption[0]).map(Path::toFile).sorted((file, file2) -> -file.compareTo((File)file2)).forEach(File::delete);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void Finds_WhiteRef_WithPrefix_SameExtAsRaw() throws IOException {
        Path path = this.tempDir.resolve("sample.raw");
        Files.writeString(path, (CharSequence)"raw", new OpenOption[0]);
        Path path2 = this.tempDir.resolve("whiteref_sample.raw");
        Files.writeString(path2, (CharSequence)"white", new OpenOption[0]);
        File file = SpectralReferenceHelper.getReferenceFile(path.toFile(), ReferenceFile.RuntimeReference.White);
        MatcherAssert.assertThat((Object)file, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)file.getAbsolutePath(), (Matcher)Matchers.equalTo((Object)path2.toString()));
    }

    @Test
    public void Finds_DarkRef_WithPrefix_UsesRawImgExt() throws IOException {
        Path path = this.tempDir.resolve("sample.img");
        Files.writeString(path, (CharSequence)"raw", new OpenOption[0]);
        Path path2 = this.tempDir.resolve("darkref_sample.img");
        Files.writeString(path2, (CharSequence)"dark", new OpenOption[0]);
        File file = SpectralReferenceHelper.getReferenceFile(path.toFile(), ReferenceFile.RuntimeReference.Dark);
        MatcherAssert.assertThat((Object)file, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)file.getAbsolutePath(), (Matcher)Matchers.equalTo((Object)path2.toString()));
    }

    @Test
    public void Finds_SuffixVariants_White_And_Dark() throws IOException {
        Path path = this.tempDir.resolve("capture.RAW");
        Files.writeString(path, (CharSequence)"raw", new OpenOption[0]);
        Path path2 = this.tempDir.resolve("capture_whiteref.raw");
        Path path3 = this.tempDir.resolve("capture_darkref.raw");
        Files.writeString(path2, (CharSequence)"white", new OpenOption[0]);
        Files.writeString(path3, (CharSequence)"dark", new OpenOption[0]);
        File file = path.toFile();
        File file2 = SpectralReferenceHelper.getReferenceFile(file, ReferenceFile.RuntimeReference.White);
        File file3 = SpectralReferenceHelper.getReferenceFile(file, ReferenceFile.RuntimeReference.Dark);
        MatcherAssert.assertThat((Object)file2, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)file3, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)file2.getAbsolutePath().toLowerCase(), (Matcher)Matchers.equalTo((Object)path2.toString().toLowerCase()));
        MatcherAssert.assertThat((Object)file3.getAbsolutePath().toLowerCase(), (Matcher)Matchers.equalTo((Object)path3.toString().toLowerCase()));
    }

    @Test
    public void Finds_SpecialCase_Wrw_Drw() throws IOException {
        Path path = this.tempDir.resolve("data.anyext");
        Files.writeString(path, (CharSequence)"raw", new OpenOption[0]);
        Path path2 = this.tempDir.resolve("data.wrw");
        Path path3 = this.tempDir.resolve("data.drw");
        Files.writeString(path2, (CharSequence)"white", new OpenOption[0]);
        Files.writeString(path3, (CharSequence)"dark", new OpenOption[0]);
        File file = path.toFile();
        File file2 = SpectralReferenceHelper.getReferenceFile(file, ReferenceFile.RuntimeReference.White);
        File file3 = SpectralReferenceHelper.getReferenceFile(file, ReferenceFile.RuntimeReference.Dark);
        MatcherAssert.assertThat((Object)file2, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)file3, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)file2.getAbsolutePath(), (Matcher)Matchers.equalTo((Object)path2.toString()));
        MatcherAssert.assertThat((Object)file3.getAbsolutePath(), (Matcher)Matchers.equalTo((Object)path3.toString()));
    }
}

