/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.measure;

import java.io.File;
import java.util.Arrays;
import org.jblas.FloatMatrix;
import org.jblas.MatrixFunctions;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.MaxSignal;

public abstract class SpectralReferenceQuality {
    private final SpectralReference reference;
    private final FloatMatrix stdevLines;
    private final float stderrLinesMaxPercent;
    private final Top95PercentMaxValues maxValues;
    protected ReferenceState state;
    protected String message;
    private final int[] edges;

    private SpectralReferenceQuality(SpectralReference spectralReference, MaxSignal maxSignal, int[] nArray) {
        this.reference = spectralReference;
        this.edges = nArray;
        FloatMatrix[] floatMatrixArray = spectralReference.getMatrix();
        this.maxValues = new Top95PercentMaxValues(SpectralReferenceQuality.calculateTop95MaxValues(floatMatrixArray));
        FloatMatrix floatMatrix = SpectralReferenceQuality.getAverageLine(floatMatrixArray);
        this.stdevLines = SpectralReferenceQuality.calculateStdevOverLines(floatMatrixArray, floatMatrix);
        this.stderrLinesMaxPercent = this.getMax(this.stdevLines, nArray) / maxSignal.value * 100.0f;
    }

    private float getMax(FloatMatrix floatMatrix, int[] nArray) {
        if (nArray != null) {
            float f = 0.0f;
            for (int i = nArray[0]; i < nArray[1]; ++i) {
                f = Math.max(f, floatMatrix.get(i));
            }
            return f;
        }
        return floatMatrix.max();
    }

    protected void checkQuality(MaxSignal maxSignal) {
        try {
            this.state = ReferenceState.Good;
            this.message = "";
            if (this.stderrLinesMaxPercent > 5.0f) {
                throw new RuntimeException("Variation over lines is higher than 5%");
            }
            this.checkQualityLocal(maxSignal);
        }
        catch (Exception exception) {
            this.message = exception.getMessage();
            this.state = ReferenceState.Error;
        }
    }

    protected abstract void checkQualityLocal(MaxSignal var1);

    private static FloatMatrix calculateStdevOverLines(FloatMatrix[] floatMatrixArray, FloatMatrix floatMatrix) {
        FloatMatrix floatMatrix2 = new FloatMatrix(1, floatMatrixArray[0].columns);
        for (FloatMatrix floatMatrix3 : floatMatrixArray) {
            FloatMatrix floatMatrix4 = floatMatrix3.columnMeans();
            floatMatrix2.addi(MatrixFunctions.powi((FloatMatrix)floatMatrix4.sub(floatMatrix), (float)2.0f));
        }
        floatMatrix2.divi((float)(floatMatrixArray.length - 1));
        return MatrixFunctions.sqrt((FloatMatrix)floatMatrix2);
    }

    private static FloatMatrix getAverageLine(FloatMatrix[] floatMatrixArray) {
        FloatMatrix floatMatrix = new FloatMatrix(1, floatMatrixArray[0].columns);
        for (FloatMatrix floatMatrix2 : floatMatrixArray) {
            FloatMatrix floatMatrix3 = floatMatrix2.columnMeans();
            floatMatrix.addi(floatMatrix3);
        }
        floatMatrix.divi((float)floatMatrixArray.length);
        return floatMatrix;
    }

    private static float[] calculateTop95MaxValues(FloatMatrix[] floatMatrixArray) {
        float[] fArray = new float[floatMatrixArray[0].columns];
        float[] fArray2 = new float[floatMatrixArray[0].rows * floatMatrixArray.length];
        for (int i = 0; i < floatMatrixArray[0].columns; ++i) {
            int n = 0;
            for (int j = 0; j < floatMatrixArray.length; ++j) {
                int n2 = 0;
                while (n2 < floatMatrixArray[j].rows) {
                    fArray2[n] = floatMatrixArray[j].get(n2, i);
                    ++n2;
                    ++n;
                }
            }
            Arrays.sort(fArray2);
            fArray[i] = fArray2[(int)((double)fArray2.length * 0.95)];
        }
        return fArray;
    }

    public FloatMatrix getStdevLines() {
        return this.stdevLines;
    }

    public float getStderrLinesMaxPercent() {
        return this.stderrLinesMaxPercent;
    }

    public Top95PercentMaxValues getMaxValues() {
        return this.maxValues;
    }

    public ReferenceState getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    public File getFile() {
        return this.reference.file();
    }

    public FrameCount getFrameCount() {
        return this.reference.header().frameCount();
    }

    public SpectralReference getReference() {
        return this.reference;
    }

    public int[] getEdges() {
        return this.edges;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(", State: " + String.valueOf((Object)this.state));
        stringBuilder.append(", Message: " + this.message);
        stringBuilder.append(", Stderr Lines: " + RtDataFormat.toString(this.getStderrLinesMaxPercent()));
        if (this instanceof WhiteReferenceQuality) {
            stringBuilder.append(", Stderr Pixels: " + RtDataFormat.toString(((WhiteReferenceQuality)this).getStderrPixelsMaxPercent()));
        }
        return stringBuilder.toString();
    }

    public static WhiteReferenceQuality fromWhiteReference(File file, MaxSignal maxSignal) {
        return new WhiteReferenceQuality(new SpectralReference.WhiteReference(file), maxSignal);
    }

    public static DarkReferenceQuality fromDarkReference(File file, MaxSignal maxSignal) {
        return new DarkReferenceQuality(new SpectralReference.DarkReference(file), maxSignal);
    }

    public static class Top95PercentMaxValues {
        private int mean = 0;
        private final float std;
        private final float stderror;
        private final float median;
        private final float min;
        private final float max;

        public Top95PercentMaxValues(float[] fArray) {
            for (float f : fArray) {
                this.mean = (int)((float)this.mean + f);
            }
            this.mean /= fArray.length;
            float f = 0.0f;
            for (float f2 : fArray) {
                float f3 = f2 - (float)this.mean;
                f += f3 * f3;
            }
            this.std = (float)Math.sqrt(f / (float)(fArray.length - 1));
            this.stderror = this.std / (float)this.mean;
            Arrays.sort(fArray);
            this.median = fArray[fArray.length / 2];
            this.min = fArray[0];
            this.max = fArray[fArray.length - 1];
        }

        public float min() {
            return this.min;
        }

        public float mean() {
            return this.mean;
        }

        public float median() {
            return this.median;
        }

        public float max() {
            return this.max;
        }

        public float std() {
            return this.std;
        }

        public float stderror() {
            return this.stderror;
        }
    }

    public static enum ReferenceState {
        Good,
        Warning,
        Error;


        public static ReferenceState parse(String string) {
            for (ReferenceState referenceState : ReferenceState.values()) {
                if (!referenceState.name().equalsIgnoreCase(string)) continue;
                return referenceState;
            }
            return Good;
        }
    }

    public static class WhiteReferenceQuality
    extends SpectralReferenceQuality {
        private final FloatMatrix stdevPixels;
        private final float stderrPixelsMaxPercent;

        public WhiteReferenceQuality(SpectralReference spectralReference, MaxSignal maxSignal) {
            super(spectralReference, maxSignal, WhiteReferenceQuality.getEdgesByPercent(spectralReference.getMatrix(), 0.1));
            this.stdevPixels = WhiteReferenceQuality.calculateStdevOverPixels(spectralReference.getMatrix(), this.getEdges());
            this.stderrPixelsMaxPercent = this.stdevPixels.max() / maxSignal.value * 100.0f;
            this.checkQuality(maxSignal);
        }

        private static int[] getEdgesByPercent(FloatMatrix[] floatMatrixArray, double d) {
            int n = floatMatrixArray[0].columns;
            int n2 = (int)((double)n * d);
            if (n2 < 10) {
                n2 = 0;
            }
            return new int[]{n2, n - n2};
        }

        private static int[] findDarkEdges(FloatMatrix[] floatMatrixArray, MaxSignal maxSignal) {
            int n = floatMatrixArray[0].columns;
            float f = (float)((double)maxSignal.value * 0.25);
            int n2 = 0;
            int n3 = n;
            for (FloatMatrix floatMatrix : floatMatrixArray) {
                int n4;
                FloatMatrix floatMatrix2 = floatMatrix.columnMeans();
                for (n4 = 0; n4 < n && floatMatrix2.get(n4) < f; ++n4) {
                    n2 = Math.max(n2, n4);
                }
                for (n4 = n - 1; n4 > 0 && floatMatrix2.get(n4) < f; --n4) {
                    n3 = Math.min(n3, n4);
                }
            }
            return new int[]{n2, n3};
        }

        private static FloatMatrix calculateStdevOverPixels(FloatMatrix[] floatMatrixArray, int[] nArray) {
            FloatMatrix floatMatrix = new FloatMatrix(floatMatrixArray.length);
            for (int i = 0; i < floatMatrixArray.length; ++i) {
                floatMatrix.put(i, WhiteReferenceQuality.mean(floatMatrixArray[i], nArray));
            }
            FloatMatrix floatMatrix2 = new FloatMatrix(floatMatrixArray.length);
            for (int i = 0; i < floatMatrixArray.length; ++i) {
                FloatMatrix floatMatrix3 = floatMatrixArray[i].columnMeans();
                for (int j = nArray[0]; j < nArray[1]; ++j) {
                    floatMatrix2.put(i, (float)Math.pow(floatMatrix.get(i) - floatMatrix3.get(j), 2.0));
                }
            }
            floatMatrix2.divi((float)(floatMatrixArray.length - 1));
            return MatrixFunctions.sqrt((FloatMatrix)floatMatrix2);
        }

        private static float mean(FloatMatrix floatMatrix, int[] nArray) {
            float f = 0.0f;
            int n = 0;
            for (int i = nArray[0]; i < nArray[1]; ++i) {
                for (int j = 0; j < floatMatrix.rows; ++j) {
                    f += floatMatrix.get(j, i);
                    ++n;
                }
            }
            return f / (float)n;
        }

        public FloatMatrix getStdevPixels() {
            return this.stdevPixels;
        }

        public float getStderrPixelsMaxPercent() {
            return this.stderrPixelsMaxPercent;
        }

        @Override
        protected void checkQualityLocal(MaxSignal maxSignal) {
            if ((double)this.getMaxValues().mean() < (double)maxSignal.value * 0.5) {
                throw new RuntimeException("White reference less than 50% of max signal");
            }
            if ((double)this.getMaxValues().mean() > (double)maxSignal.value * 0.99) {
                throw new RuntimeException("White reference over 99% of max signal, possible saturation");
            }
            if (this.stderrPixelsMaxPercent > 5.0f) {
                throw new RuntimeException("Variation over pixels is higher than 5%");
            }
        }
    }

    public static class DarkReferenceQuality
    extends SpectralReferenceQuality {
        public DarkReferenceQuality(SpectralReference spectralReference, MaxSignal maxSignal) {
            super(spectralReference, maxSignal, null);
            this.checkQuality(maxSignal);
        }

        @Override
        protected void checkQualityLocal(MaxSignal maxSignal) {
            if ((double)this.getMaxValues().mean() > (double)maxSignal.value * 0.7) {
                throw new RuntimeException("Dark reference over 70% of max signal");
            }
        }
    }
}

