/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.measure;

import java.io.File;
import lombok.Generated;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;

public class SpectralReferenceSettings {
    private int whiteReferenceDelay = 0;
    private int darkReferenceDelay = 0;
    private int referenceFrames = 25;

    public SpectralReferenceSettings(File file) {
        Node node = XmlParserHelper.parseXMLRoot(file, "root");
        Node node2 = XmlParserHelper.getNodeList(node, "measurement").getFirst();
        for (Node node3 : XmlParserHelper.getNodeList(node2)) {
            switch (node3.getNodeName()) {
                case "whiteRefValid": {
                    this.whiteReferenceDelay = RtDataFormat.toNumberInt(node3.getTextContent());
                    break;
                }
                case "darkRefValid": {
                    this.darkReferenceDelay = RtDataFormat.toNumberInt(node3.getTextContent());
                    break;
                }
                case "referenceFrames": {
                    this.referenceFrames = RtDataFormat.toNumberInt(node3.getTextContent());
                }
            }
        }
    }

    public int getWhitReferenceDelay() {
        return this.whiteReferenceDelay;
    }

    public FrameCount getReferenceFrames() {
        return new FrameCount(this.referenceFrames);
    }

    @Generated
    public int getDarkReferenceDelay() {
        return this.darkReferenceDelay;
    }
}

