/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.measure;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.measure.ReferenceFile;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFileWriter;
import se.prediktera.breeze.common.util.raw.RawHeader;

public class WhiteIntensityHelper {
    public static void createWhiteIntensityInFolder(File file, File file2) {
        List<Frame> list = WhiteIntensityHelper.createWhiteIntensity(file, file2);
        String string = "whiteintensityref" + file2.getName().substring("whiteref".length(), file2.getName().length() - 4);
        RawFileWriter.writeFramesAndHeader(file2.getParentFile(), string, list);
    }

    public static List<Frame> createWhiteIntensity(File file, File file2) {
        RawHeader rawHeader = RawHeader.findByRaw(file);
        FrameListFromRaw frameListFromRaw = new FrameListFromRaw(file, rawHeader);
        if (frameListFromRaw.isEmpty()) {
            throw new RuntimeException("No dark frames");
        }
        RawFrame rawFrame = (RawFrame)frameListFromRaw.get(0);
        RawHeader rawHeader2 = RawHeader.findByRaw(file2);
        FrameListFromRaw frameListFromRaw2 = new FrameListFromRaw(file2, rawHeader2);
        if (frameListFromRaw2.isEmpty()) {
            throw new RuntimeException("No white frames");
        }
        RawFrame rawFrame2 = (RawFrame)frameListFromRaw2.get(0);
        if (rawFrame.columns.value != rawFrame2.columns.value || rawFrame.rows.value != rawFrame2.rows.value) {
            throw new RuntimeException("Dark frame dimension and white frame dimension does not agree");
        }
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        for (int i = 0; i < frameListFromRaw2.size(); ++i) {
            RawFrame rawFrame3 = (RawFrame)frameListFromRaw2.get(i);
            RawFrame rawFrame4 = (RawFrame)frameListFromRaw.get(i % frameListFromRaw.size());
            RawFrame rawFrame5 = Frame.createFrame(rawFrame.getType(), rawFrame.rows, rawFrame.columns, rawFrame.bandNames);
            for (int j = 0; j < rawFrame4.getColumns().value; ++j) {
                for (int k = 0; k < rawFrame4.getRows().value; ++k) {
                    rawFrame5.setFrameValue(k, j, rawFrame3.getFrameValue(k, j) - rawFrame4.getFrameValue(k, j));
                }
            }
            arrayList.add(rawFrame5);
        }
        return arrayList;
    }

    public static SpectralReference.WhiteReference createWhiteReference(File file, File file2) {
        FrameListFromRaw frameListFromRaw = new FrameListFromRaw(file);
        FrameListFromRaw frameListFromRaw2 = new FrameListFromRaw(file2);
        for (int i = 0; i < frameListFromRaw.size(); ++i) {
            RawFrame rawFrame = (RawFrame)frameListFromRaw.get(i);
            RawFrame rawFrame2 = (RawFrame)frameListFromRaw2.get(i);
            for (int j = 0; j < rawFrame.getColumns().value; ++j) {
                for (int k = 0; k < rawFrame.getRows().value; ++k) {
                    rawFrame2.setFrameValue(k, j, rawFrame.getFrameValue(k, j) + rawFrame2.getFrameValue(k, j));
                }
            }
        }
        return new SpectralReference.WhiteReference(frameListFromRaw2, frameListFromRaw2.getHeader());
    }

    public static boolean isWhiteIntensityFile(File file) {
        try {
            return new ReferenceFile(file).getType().equals((Object)ReferenceFile.RuntimeReference.WhiteIntensity);
        }
        catch (ReferenceFile.NoReferenceFileException noReferenceFileException) {
            return false;
        }
    }
}

