/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.performance;

import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.type.FrameRate;

public class MeasuredFps {
    private long startTime;
    private long endTime;
    private int frameIndex;

    public void increase() {
        if (this.frameIndex++ == 0) {
            this.startTime = System.currentTimeMillis();
        }
        this.endTime = System.currentTimeMillis();
    }

    public void reset() {
        this.frameIndex = 0;
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public FrameRate getActual() {
        long l = this.getTime().ms;
        return new FrameRate((float)((double)this.frameIndex * 1000.0 / (double)l));
    }

    public Time getTime() {
        return new Time.MilliSeconds(this.endTime - this.startTime);
    }

    public String toString() {
        return this.getActual().toString();
    }
}

