/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.performance;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.util.Time;

public class PerformanceSummary {
    private final int frames;
    private final int threads;
    private final List<Long> times = new ArrayList<Long>();
    private long start;

    public PerformanceSummary(int n, int n2) {
        this.frames = n;
        this.threads = n2;
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public void stop() {
        this.times.add(System.currentTimeMillis() - this.start);
    }

    public String toString() {
        Long l = 0L;
        Long l2 = Long.MAX_VALUE;
        for (Long l3 : this.times) {
            l = l + l3;
            l2 = Math.min(l2, l3);
        }
        l = l / (long)this.times.size();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Threads: " + this.threads);
        stringBuilder.append(", min=" + String.valueOf(new Time.MilliSeconds(l2)));
        stringBuilder.append(", average=" + String.valueOf(new Time.MilliSeconds(l)));
        stringBuilder.append("\t" + (int)((float)(this.frames * 1000) / (float)l.longValue()));
        return stringBuilder.toString();
    }
}

