/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.performance;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class TasklistProcess {
    private final String name;
    private final int pid;
    private final String sessionName;
    private final String session;
    private final int memUsage;

    public TasklistProcess(String string) {
        String string2 = TasklistProcess.getFirstTaskListProcessLine(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
        this.name = stringTokenizer.nextToken();
        this.pid = Integer.parseInt(stringTokenizer.nextToken());
        this.sessionName = stringTokenizer.nextToken();
        this.session = stringTokenizer.nextToken();
        this.memUsage = this.parseMemUsage(stringTokenizer);
    }

    private int parseMemUsage(StringTokenizer stringTokenizer) {
        StringBuilder stringBuilder = new StringBuilder(stringTokenizer.nextToken());
        for (int i = stringBuilder.length() - 1; i >= 0; --i) {
            if (Character.isDigit(stringBuilder.charAt(i))) continue;
            stringBuilder.deleteCharAt(i);
        }
        return Integer.parseInt(stringBuilder.toString());
    }

    public String getName() {
        return this.name;
    }

    public int getPid() {
        return this.pid;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public String getSession() {
        return this.session;
    }

    public int getMemUsage() {
        return this.memUsage;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("name=" + this.name);
        stringBuilder.append(", pid=" + this.pid);
        stringBuilder.append(", sessionName=" + this.sessionName);
        stringBuilder.append(", session=" + this.session);
        stringBuilder.append(", memUsage=" + this.memUsage);
        return stringBuilder.toString();
    }

    public static String getFirstTaskListProcessLine(String ... stringArray) {
        return TasklistProcess.getFirstTaskListProcessLine(new ProcessBuilder("tasklist"), stringArray);
    }

    public static String getFirstTaskListProcessLineMac(String ... stringArray) {
        return TasklistProcess.getFirstTaskListProcessLine(new ProcessBuilder("ps", "-A"), stringArray);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getFirstTaskListProcessLine(ProcessBuilder processBuilder, String ... stringArray) {
        try {
            Process process = processBuilder.start();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "CP437"));){
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    for (String string2 : stringArray) {
                        if (!string.contains(string2)) continue;
                        String string3 = string;
                        return string3;
                    }
                }
                String[] stringArray2 = null;
                return stringArray2;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void main(String[] stringArray) {
        TasklistProcess tasklistProcess = new TasklistProcess("BreezeRuntime.exe");
        System.out.println(tasklistProcess);
    }
}

