/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.polynom;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.util.RtDataFormat;

public class RtPolyNode
implements Cloneable {
    protected int id;
    protected int type;
    protected RtPolyNode left;
    protected RtPolyNode right;
    protected Object[] objectArray;
    private float num;
    private boolean included = false;
    private boolean isnumerical;
    private String variable;

    public RtPolyNode(int n, float f) {
        this.type = n;
        this.num = f;
    }

    public RtPolyNode(String string, float f) {
        this(string);
        this.num = f;
    }

    public RtPolyNode(String string) {
        this.type = 6;
        this.variable = string;
    }

    public RtPolyNode(RtPolyNode rtPolyNode, int n, RtPolyNode rtPolyNode2) {
        this.left = rtPolyNode;
        this.type = n;
        this.right = rtPolyNode2;
    }

    public Object clone() {
        try {
            RtPolyNode rtPolyNode = (RtPolyNode)super.clone();
            if (this.left != null) {
                rtPolyNode.setLeft((RtPolyNode)this.left.clone());
            }
            if (this.right != null) {
                rtPolyNode.setRight((RtPolyNode)this.right.clone());
            }
            return rtPolyNode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int getId() {
        return this.id;
    }

    public String getVariable() {
        return this.variable;
    }

    public RtPolyNode getLeft() {
        return this.left;
    }

    public double getNum() {
        return this.num;
    }

    public Object[] getParam() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.createParam(arrayList);
        return arrayList.toArray();
    }

    public RtPolyNode getRight() {
        return this.right;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return (double)this.num;
    }

    public String getValueStr() {
        Object object = this.getValue();
        if (object instanceof Double) {
            return RtDataFormat.toString((Double)object);
        }
        if (object instanceof Object[]) {
            StringBuilder stringBuilder = new StringBuilder();
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(objectArray[i]);
            }
            return stringBuilder.toString();
        }
        if (object instanceof Double[]) {
            StringBuilder stringBuilder = new StringBuilder();
            Double[] doubleArray = (Double[])object;
            for (int i = 0; i < doubleArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(doubleArray[i]);
            }
            return stringBuilder.toString();
        }
        if (object instanceof double[]) {
            StringBuilder stringBuilder = new StringBuilder();
            double[] dArray = (double[])object;
            for (int i = 0; i < dArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(dArray[i]);
            }
            return stringBuilder.toString();
        }
        return String.valueOf(object);
    }

    public boolean isIncluded() {
        return this.included;
    }

    public boolean isNumerical() {
        return this.isnumerical;
    }

    public void setId(int n) {
        this.id = n;
    }

    public void setIncluded(boolean bl) {
        this.included = bl;
    }

    public void setLeft(RtPolyNode rtPolyNode) {
        this.left = rtPolyNode;
    }

    public void setNum(float f) {
        this.num = f;
        this.isnumerical = true;
    }

    public void setNumerical(boolean bl) {
        this.isnumerical = bl;
    }

    public void setRight(RtPolyNode rtPolyNode) {
        this.right = rtPolyNode;
    }

    public void setType(int n) {
        this.type = n;
    }

    protected void createParam(List<Object> list) {
        if (this.type == 44) {
            if (this.left != null) {
                this.left.createParam(list);
            }
            if (this.right != null) {
                this.right.createParam(list);
            }
        } else if (this.type == 35) {
            list.add("#");
        } else if (this.objectArray != null) {
            list.add(this.objectArray);
        } else {
            list.add(this.getValue());
        }
    }

    public String toString() {
        if (this.type == 6) {
            return "PolyNode: " + this.variable + "=" + this.num;
        }
        return super.toString();
    }

    public boolean hasBothChildren() {
        return this.left != null && this.right != null;
    }

    public boolean hasChildren() {
        return this.left != null || this.right != null;
    }
}

