/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.polynom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.prediktera.breeze.common.util.polynom.RtLexikator;
import se.prediktera.breeze.common.util.polynom.RtPolyNode;
import se.prediktera.breeze.common.util.polynom.RtPolynomException;
import se.prediktera.breeze.common.util.polynom.RtPolynomInterface;

public class RtPolynomParser
implements RtPolynomInterface {
    private RtPolyNode root = null;
    private int curId = -1;
    private final RtLexikator lexikator;
    private final List<RtPolyNode> idList = new ArrayList<RtPolyNode>();

    public RtPolynomParser() {
        this.lexikator = this.createLexikator();
    }

    public RtPolynomParser(String string, RtPolyNode[] rtPolyNodeArray) {
        this();
        this.parse(string, rtPolyNodeArray);
    }

    public boolean evaluateRelation() {
        return this.evaluate() > 0.0f;
    }

    public float evaluate() {
        return this.recExecute(this.root);
    }

    public RtPolyNode executeFunction(RtPolyNode rtPolyNode) throws RtPolynomException {
        return null;
    }

    public synchronized RtPolyNode parse(String string, RtPolyNode[] rtPolyNodeArray) throws RtPolynomException {
        this.idList.clear();
        if (string == null || string.length() == 0) {
            throw new RtPolynomException("Expression is empty");
        }
        string = string.replace(">=", "]");
        string = string.replace("<=", "[");
        string = string.replace("<>", "!");
        string = string.replace("!=", "!");
        if (rtPolyNodeArray != null) {
            this.idList.addAll(Arrays.asList(rtPolyNodeArray));
        }
        if (rtPolyNodeArray != null) {
            for (RtPolyNode rtPolyNode : rtPolyNodeArray) {
                rtPolyNode.setIncluded(false);
            }
        }
        this.lexikator.setPolynom(string);
        this.curId = this.lexikator.getTokenID();
        while (this.curId != 0) {
            this.root = this.expression();
        }
        return this.root;
    }

    public String getPolynom() {
        return this.lexikator.getPolynom();
    }

    protected RtLexikator createLexikator() {
        return new RtLexikator();
    }

    protected RtPolyNode expression() throws RtPolynomException {
        RtPolyNode rtPolyNode = this.term();
        while (true) {
            switch (this.curId) {
                case 38: 
                case 43: 
                case 45: 
                case 124: {
                    break;
                }
                default: {
                    return rtPolyNode;
                }
            }
            int n = this.match(this.curId);
            rtPolyNode = new RtPolyNode(rtPolyNode, n, this.term());
        }
    }

    protected RtPolyNode factor() throws RtPolynomException {
        int n = this.curId;
        return switch (n) {
            case 40 -> {
                this.match(40);
                RtPolyNode var1_2 = new RtPolyNode(null, 7, this.expression());
                this.match(41);
                yield var1_2;
            }
            case 45 -> {
                this.match(45);
                yield new RtPolyNode(null, 8, this.factor());
            }
            case 4, 5, 10, 12, 13, 14, 15 -> {
                this.match(n);
                this.match(40);
                RtPolyNode var1_3 = new RtPolyNode(null, n, this.expression());
                this.match(41);
                yield var1_3;
            }
            case 3 -> {
                RtPolyNode var1_4 = new RtPolyNode(n, this.lexikator.getDouble());
                this.match(n);
                yield var1_4;
            }
            case 11 -> {
                RtPolyNode var1_5 = new RtPolyNode(3, Float.POSITIVE_INFINITY);
                this.match(n);
                yield var1_5;
            }
            case 16 -> {
                this.match(n);
                this.match(40);
                RtPolyNode var1_6 = this.getIdNode("AVG#" + this.lexikator.getVariable());
                this.expression();
                var1_6.setIncluded(true);
                this.match(41);
                yield var1_6;
            }
            case 6 -> {
                RtPolyNode var1_7 = this.getIdNode(this.lexikator.getVariable());
                var1_7.setIncluded(true);
                this.match(n);
                yield var1_7;
            }
            default -> throw new RtPolynomException("Syntax error");
        };
    }

    protected RtPolyNode getIdNode(String string) throws RtPolynomException {
        for (RtPolyNode rtPolyNode : this.idList) {
            if (!rtPolyNode.getVariable().equals(string)) continue;
            return rtPolyNode;
        }
        RtPolyNode rtPolyNode = new RtPolyNode(string);
        this.idList.add(rtPolyNode);
        return rtPolyNode;
    }

    public List<RtPolyNode> getIdList() {
        return this.idList;
    }

    protected int match(int n) throws RtPolynomException {
        if (this.curId != n) {
            throw new RtPolynomException("Missing match \"" + this.getIdName(n) + "\"");
        }
        this.curId = this.lexikator.getTokenID();
        return n;
    }

    protected final float recExecute(RtPolyNode rtPolyNode) {
        switch (rtPolyNode.getType()) {
            case 43: {
                return this.recExecute(rtPolyNode.getLeft()) + this.recExecute(rtPolyNode.getRight());
            }
            case 45: {
                return this.recExecute(rtPolyNode.getLeft()) - this.recExecute(rtPolyNode.getRight());
            }
            case 42: {
                return this.recExecute(rtPolyNode.getLeft()) * this.recExecute(rtPolyNode.getRight());
            }
            case 47: {
                return this.recExecute(rtPolyNode.getLeft()) / this.recExecute(rtPolyNode.getRight());
            }
            case 61: {
                return Double.compare(this.recExecute(rtPolyNode.getLeft()), this.recExecute(rtPolyNode.getRight())) == 0 ? 1.0f : 0.0f;
            }
            case 33: {
                return Double.compare(this.recExecute(rtPolyNode.getLeft()), this.recExecute(rtPolyNode.getRight())) == 0 ? 0.0f : 1.0f;
            }
            case 38: {
                return this.recExecute(rtPolyNode.getLeft()) > 0.0f && this.recExecute(rtPolyNode.getRight()) > 0.0f ? 1.0f : 0.0f;
            }
            case 124: {
                return this.recExecute(rtPolyNode.getLeft()) > 0.0f || this.recExecute(rtPolyNode.getRight()) > 0.0f ? 1.0f : 0.0f;
            }
            case 62: {
                return this.recExecute(rtPolyNode.getLeft()) > this.recExecute(rtPolyNode.getRight()) ? 1.0f : 0.0f;
            }
            case 60: {
                return this.recExecute(rtPolyNode.getLeft()) < this.recExecute(rtPolyNode.getRight()) ? 1.0f : 0.0f;
            }
            case 93: {
                return this.recExecute(rtPolyNode.getLeft()) >= this.recExecute(rtPolyNode.getRight()) ? 1.0f : 0.0f;
            }
            case 91: {
                return this.recExecute(rtPolyNode.getLeft()) <= this.recExecute(rtPolyNode.getRight()) ? 1.0f : 0.0f;
            }
            case 7: {
                return this.recExecute(rtPolyNode.getRight());
            }
            case 4: {
                return (float)Math.sin(this.recExecute(rtPolyNode.getRight()));
            }
            case 5: {
                return (float)Math.cos(this.recExecute(rtPolyNode.getRight()));
            }
            case 10: {
                double d = this.recExecute(rtPolyNode.getRight());
                if (d > 0.0) {
                    return (float)Math.log10(d);
                }
                return 0.0f;
            }
            case 12: {
                double d = this.recExecute(rtPolyNode.getRight());
                if (d > 0.0) {
                    return (float)Math.sqrt(d);
                }
                return 0.0f;
            }
            case 13: {
                double d = this.recExecute(rtPolyNode.getRight());
                if (d > 0.0) {
                    return (float)Math.exp(d);
                }
                return 0.0f;
            }
            case 14: {
                return (int)this.recExecute(rtPolyNode.getRight());
            }
            case 15: {
                return Math.round(this.recExecute(rtPolyNode.getRight()));
            }
            case 94: {
                return (float)Math.pow(this.recExecute(rtPolyNode.getLeft()), this.recExecute(rtPolyNode.getRight()));
            }
            case 37: {
                return (int)this.recExecute(rtPolyNode.getLeft()) % (int)this.recExecute(rtPolyNode.getRight());
            }
            case 8: {
                return -this.recExecute(rtPolyNode.getRight());
            }
            case 3: 
            case 6: 
            case 2002: {
                return (float)rtPolyNode.getNum();
            }
            case 2001: {
                try {
                    RtPolyNode rtPolyNode2 = this.executeFunction(rtPolyNode);
                    if (rtPolyNode2 != null && rtPolyNode2.getValue() instanceof Double) {
                        return ((Double)rtPolyNode2.getValue()).floatValue();
                    }
                    break;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        return 0.0f;
    }

    protected RtPolyNode term() throws RtPolynomException {
        RtPolyNode rtPolyNode = this.factor();
        while (true) {
            switch (this.curId) {
                case 33: 
                case 37: 
                case 42: 
                case 47: 
                case 60: 
                case 61: 
                case 62: 
                case 91: 
                case 93: 
                case 94: {
                    break;
                }
                default: {
                    return rtPolyNode;
                }
            }
            int n = this.match(this.curId);
            rtPolyNode = new RtPolyNode(rtPolyNode, n, this.factor());
        }
    }

    private String getIdName(int n) {
        return switch (n) {
            case 2001 -> "Method";
            case 2002 -> "Variable";
            case 2003 -> "Variable Array";
            case 2004 -> "Tag";
            case 3001 -> "If";
            case 3002 -> "While";
            case 3003 -> "Foreach";
            case 3004 -> "End";
            case 4001 -> "Expression";
            default -> String.valueOf((char)n);
        };
    }

    public RtPolyNode getRoot() {
        return this.root;
    }
}

