/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawFileWriter;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.entry.measurement.Measurement;

public class CachedRawFile
implements RawFile {
    private List<RawFrame> frames;
    private final RawHeader header;
    private Measurement measurement;
    private final MeasurementFileLocation fileLocation;
    private File file;
    private ByteBuffer binaryHeader;
    private FrameListFromRaw.Reduce reduce = FrameListFromRaw.Reduce.Original;

    public CachedRawFile(List<RawFrame> list, RawHeader rawHeader, MeasurementFileLocation measurementFileLocation) {
        this.frames = list;
        this.header = rawHeader;
        this.fileLocation = measurementFileLocation;
    }

    public CachedRawFile(File file) {
        this.file = file;
        this.header = RawHeader.findByRaw(this.file());
        this.fileLocation = null;
    }

    public CachedRawFile(Measurement measurement, MeasurementFileLocation measurementFileLocation) throws FileNotFoundException {
        this.measurement = measurement;
        this.fileLocation = measurementFileLocation;
        if (this.file() == null) {
            throw new RuntimeException("Cant create raw file from null file");
        }
        if (!this.file().exists()) {
            throw new FileNotFoundException(String.format("Cant create raw file, file not found: %s", this.file()));
        }
        this.header = RawHeader.findByRaw(this.file());
    }

    public CachedRawFile(Measurement measurement, MeasurementFileLocation measurementFileLocation, FrameListFromRaw.Reduce reduce) throws FileNotFoundException {
        this(measurement, measurementFileLocation);
        this.reduce = reduce;
        FrameListFromRaw frameListFromRaw = new FrameListFromRaw(this.file(), reduce);
        if (reduce.isReduced()) {
            this.frames = new ArrayList<RawFrame>();
            for (int i = 0; i < frameListFromRaw.size(); ++i) {
                this.frames.add(((RawFrame)frameListFromRaw.get(i)).recudeFrame(reduce));
            }
            this.header.setReducedSize(new FrameCount(this.frames.size()), this.frames.isEmpty() ? new PixelWidth(0) : this.frames.get((int)0).columns);
        } else {
            this.frames = frameListFromRaw;
        }
    }

    @Override
    public RawHeader header() {
        return this.header;
    }

    @Override
    public ByteBuffer readRawHeader() {
        if (this.binaryHeader == null) {
            this.binaryHeader = FrameListFromRaw.readRawHeader(this.file(), this.header());
        }
        return this.binaryHeader;
    }

    public ByteBuffer readMeasurementRawHeader() {
        if (this.measurement != null) {
            return this.measurement.rawFile().readRawHeader();
        }
        return null;
    }

    public boolean hasFrames() {
        return this.frames != null;
    }

    @Override
    public List<RawFrame> readFrames() {
        if (this.frames == null) {
            this.frames = new FrameListFromRaw(this.file(), this.getDefaultReduce());
        }
        return this.frames;
    }

    public FrameListFromRaw.Reduce getReduce() {
        return this.reduce;
    }

    protected FrameListFromRaw.Reduce getDefaultReduce() {
        return FrameListFromRaw.Reduce.Original;
    }

    @Override
    public File file() {
        if (this.measurement != null) {
            return this.fileLocation.file(this.measurement);
        }
        return this.file;
    }

    public void write(Measurement measurement, String string, Rectangle rectangle) {
        this.measurement = measurement;
        this.write(this.file(), string, rectangle);
    }

    public void write(File file, String string, Rectangle rectangle) {
        this.file = file;
        RawFileWriter.writeFramesAndHeader(file, this.frames, this.header(), string, rectangle, null);
    }

    public static class FakeRawFile
    extends CachedRawFile {
        public FakeRawFile() {
            super(null, new RawHeader(FrameCount.Continuously, new BandCount(0), new PixelWidth(0)), (Measurement measurement) -> null);
        }

        public FakeRawFile(List<RawFrame> list, RawHeader rawHeader) {
            super(list, rawHeader, (Measurement measurement) -> null);
        }

        public FakeRawFile(List<RawFrame> list) {
            this(list, new RawHeader(new FrameCount(list.size()), list.get(0).getRows(), list.get(0).getColumns()));
        }
    }
}

