/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;

public final class EnviGeoHelper
extends RtDataFormat {
    private final String projectionName;
    private final int refPixelX;
    private final int refPixelY;
    private final double refEasting;
    private final double refNorthing;
    private final double pixelSizeX;
    private final double pixelSizeY;
    private final Integer utmZone;
    private final String hemisphere;
    private final String datum;
    private final String units;
    private final String coordinateSystemString;

    private EnviGeoHelper(String string, int n, int n2, double d, double d2, double d3, double d4, Integer n3, String string2, String string3, String string4, String string5) {
        this.projectionName = string;
        this.refPixelX = n;
        this.refPixelY = n2;
        this.refEasting = d;
        this.refNorthing = d2;
        this.pixelSizeX = d3;
        this.pixelSizeY = d4;
        this.utmZone = n3;
        this.hemisphere = string2;
        this.datum = string3;
        this.units = string4;
        this.coordinateSystemString = string5;
    }

    public static EnviGeoHelper parse(String string, String string2, String string3) {
        List<String> list;
        List<String> list2;
        String string4;
        String string5 = null;
        int n = 1;
        int n2 = 1;
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        Integer n3 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        if (string != null && (string4 = EnviGeoHelper.betweenBraces(string)) != null) {
            list2 = EnviGeoHelper.splitCsv(string4);
            if (list2.size() >= 7) {
                string5 = EnviGeoHelper.stripQuotes((String)list2.get(0));
                n = EnviGeoHelper.toNumberInt((String)list2.get(1), 1);
                n2 = EnviGeoHelper.toNumberInt((String)list2.get(2), 1);
                d = EnviGeoHelper.toNumber((String)list2.get(3));
                d2 = EnviGeoHelper.toNumber((String)list2.get(4));
                d3 = EnviGeoHelper.toNumber((String)list2.get(5));
                d4 = EnviGeoHelper.toNumber((String)list2.get(6));
            }
            for (int i = 7; i < list2.size(); ++i) {
                String string9 = ((String)list2.get(i)).trim();
                if (n3 == null && EnviGeoHelper.isInteger(string9)) {
                    n3 = Integer.parseInt(string9);
                    continue;
                }
                if (string6 == null && (StringHelper.equalsIgnoreCase((String)string9, (String)"North") || StringHelper.equalsIgnoreCase((String)string9, (String)"South"))) {
                    string6 = EnviGeoHelper.stripQuotes(string9);
                    continue;
                }
                if (string7 == null && string9.matches("(?i)WGS.*|NAD.*|.*\\b1984\\b.*")) {
                    string7 = EnviGeoHelper.stripQuotes(string9);
                    continue;
                }
                if (!string9.toLowerCase().startsWith("units=")) continue;
                String[] stringArray = string9.split("=", 2);
                string8 = stringArray.length == 2 ? EnviGeoHelper.stripQuotes(stringArray[1]) : null;
            }
        }
        string4 = null;
        if (string2 != null && (string4 = EnviGeoHelper.betweenBraces(string2)) != null) {
            string4 = string4.trim();
        }
        if (string3 != null && (list2 = EnviGeoHelper.betweenBraces(string3)) != null && (list = EnviGeoHelper.splitCsv((String)((Object)list2))).size() >= 2) {
            d3 = EnviGeoHelper.toNumber(list.get(0));
            d4 = EnviGeoHelper.toNumber(list.get(1));
        }
        if (string5 == null) {
            string5 = "Unknown";
        }
        if (Double.isNaN(d3) || Double.isNaN(d4)) {
            throw new IllegalArgumentException("Pixel size not found in 'map info' or 'pixel size' header lines.");
        }
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Reference tie-point not found in 'map info' header line.");
        }
        return new EnviGeoHelper(string5, n, n2, d, d2, d3, d4, n3, string6, string7, string8, string4);
    }

    public Point2D.Double pixelToMap(double d, double d2) {
        double d3 = (d - (double)this.refPixelX) * this.pixelSizeX;
        double d4 = (d2 - (double)this.refPixelY) * this.pixelSizeY;
        double d5 = this.refEasting + d3;
        double d6 = this.refNorthing - d4;
        return new Point2D.Double(d5, d6);
    }

    public Point2D.Double mapToPixel(double d, double d2) {
        double d3 = d - this.refEasting;
        double d4 = this.refNorthing - d2;
        double d5 = d3 / this.pixelSizeX + (double)this.refPixelX;
        double d6 = d4 / this.pixelSizeY + (double)this.refPixelY;
        return new Point2D.Double(d5, d6);
    }

    public EnviGeoHelper forCrop0Based(int n, int n2) {
        return this.forCrop(n + 1, n2 + 1);
    }

    protected EnviGeoHelper forCrop(int n, int n2) {
        Point2D.Double double_ = this.pixelToMap(n, n2);
        return new EnviGeoHelper(this.projectionName, 1, 1, double_.x, double_.y, this.pixelSizeX, this.pixelSizeY, this.utmZone, this.hemisphere, this.datum, this.units, this.coordinateSystemString);
    }

    public EnviGeoHelper withResampledPixelSize(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("scaleX and scaleY must be > 0");
        }
        double d3 = this.pixelSizeX * d;
        double d4 = this.pixelSizeY * d2;
        return new EnviGeoHelper(this.projectionName, this.refPixelX, this.refPixelY, this.refEasting, this.refNorthing, d3, d4, this.utmZone, this.hemisphere, this.datum, this.units, this.coordinateSystemString);
    }

    public String toMapInfoLine() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.projectionName).append(", ").append(this.refPixelX).append(", ").append(this.refPixelY).append(", ").append(EnviGeoHelper.fmt(this.refEasting)).append(", ").append(EnviGeoHelper.fmt(this.refNorthing)).append(", ").append(EnviGeoHelper.fmt(this.pixelSizeX)).append(", ").append(EnviGeoHelper.fmt(this.pixelSizeY));
        if (this.utmZone != null) {
            stringBuilder.append(",").append(this.utmZone);
        }
        if (this.hemisphere != null) {
            stringBuilder.append(",").append(this.hemisphere);
        }
        if (this.datum != null) {
            stringBuilder.append(",").append(this.datum);
        }
        if (this.units != null) {
            stringBuilder.append(",units=").append(this.units);
        }
        return stringBuilder.toString();
    }

    public String toPixelSizeLine() {
        return EnviGeoHelper.fmt(this.pixelSizeX) + ", " + EnviGeoHelper.fmt(this.pixelSizeY);
    }

    public String toCoordinateSystemStringLine() {
        return this.coordinateSystemString;
    }

    private static String betweenBraces(String string) {
        int n = string.indexOf(123);
        int n2 = string.lastIndexOf(125);
        if (n >= 0 && n2 > n) {
            return string.substring(n + 1, n2);
        }
        return string;
    }

    private static List<String> splitCsv(String string) {
        String[] stringArray = string.split(",");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    private static String stripQuotes(String string) {
        String string2 = string.trim();
        if (string2.startsWith("\"") && string2.endsWith("\"") || string2.startsWith("'") && string2.endsWith("'")) {
            return string2.substring(1, string2.length() - 1);
        }
        return string2;
    }

    private static String fmt(double d) {
        return String.format(Locale.ROOT, "%.9f", d).replaceAll("0+$", "").replaceAll("\\.$", ".0");
    }

    public double getPixelSizeX() {
        return this.pixelSizeX;
    }

    public double getPixelSizeY() {
        return this.pixelSizeY;
    }

    public String getCoordinateSystemString() {
        return this.coordinateSystemString;
    }

    public String getProjectionName() {
        return this.projectionName;
    }

    public Integer getUtmZone() {
        return this.utmZone;
    }

    public String getHemisphere() {
        return this.hemisphere;
    }

    public String getDatum() {
        return this.datum;
    }

    public String getUnits() {
        return this.units;
    }
}

