/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.awt.geom.Point2D;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import se.prediktera.breeze.common.util.raw.EnviGeoHelper;

public class EnviGeoHelperTest {
    private static final String MAP_INFO = "map info = {UTM, 1, 1, 588084.940, 3552005.020, 0.140000, 0.140000,12,North,WGS-84,units=Meter}";
    private static final String COORD_SYS = "coordinate system string = {PROJCS[\"WGS_1984_UTM_Zone_12N\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-111.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]}";
    private static final String PIXEL_SIZE = "pixel size = {0.140000, 0.140000}";
    private static final double EPS = 1.0E-9;

    @Test
    public void parseHeader() {
        EnviGeoHelper enviGeoHelper = EnviGeoHelper.parse(MAP_INFO, COORD_SYS, PIXEL_SIZE);
        MatcherAssert.assertThat((Object)enviGeoHelper.getProjectionName(), (Matcher)Matchers.equalTo((Object)"UTM"));
        MatcherAssert.assertThat((Object)enviGeoHelper.getUtmZone(), (Matcher)Matchers.equalTo((Object)12));
        MatcherAssert.assertThat((Object)enviGeoHelper.getHemisphere(), (Matcher)Matchers.equalTo((Object)"North"));
        MatcherAssert.assertThat((Object)enviGeoHelper.getDatum(), (Matcher)Matchers.equalTo((Object)"WGS-84"));
        MatcherAssert.assertThat((Object)enviGeoHelper.getUnits(), (Matcher)Matchers.equalTo((Object)"Meter"));
        MatcherAssert.assertThat((Object)enviGeoHelper.getPixelSizeX(), (Matcher)Matchers.closeTo((double)0.14, (double)1.0E-9));
        MatcherAssert.assertThat((Object)enviGeoHelper.getPixelSizeY(), (Matcher)Matchers.closeTo((double)0.14, (double)1.0E-9));
        MatcherAssert.assertThat((Object)enviGeoHelper.getCoordinateSystemString(), (Matcher)Matchers.startsWith((String)"PROJCS[\"WGS_1984_UTM_Zone_12N\""));
    }

    @Test
    public void pixelToMapAtTiePoint() {
        EnviGeoHelper enviGeoHelper = EnviGeoHelper.parse(MAP_INFO, COORD_SYS, PIXEL_SIZE);
        Point2D.Double double_ = enviGeoHelper.pixelToMap(1.0, 1.0);
        MatcherAssert.assertThat((Object)double_.x, (Matcher)Matchers.closeTo((double)588084.94, (double)1.0E-9));
        MatcherAssert.assertThat((Object)double_.y, (Matcher)Matchers.closeTo((double)3552005.02, (double)1.0E-9));
    }

    @Test
    public void pixelToMapNeighborPixels() {
        EnviGeoHelper enviGeoHelper = EnviGeoHelper.parse(MAP_INFO, COORD_SYS, PIXEL_SIZE);
        Point2D.Double double_ = enviGeoHelper.pixelToMap(2.0, 1.0);
        MatcherAssert.assertThat((Object)double_.x, (Matcher)Matchers.closeTo((double)588085.08, (double)1.0E-9));
        MatcherAssert.assertThat((Object)double_.y, (Matcher)Matchers.closeTo((double)3552005.02, (double)1.0E-9));
        Point2D.Double double_2 = enviGeoHelper.pixelToMap(1.0, 2.0);
        MatcherAssert.assertThat((Object)double_2.x, (Matcher)Matchers.closeTo((double)588084.94, (double)1.0E-9));
        MatcherAssert.assertThat((Object)double_2.y, (Matcher)Matchers.closeTo((double)3552004.88, (double)1.0E-9));
    }

    @Test
    public void roundTripMapAndPixel() {
        EnviGeoHelper enviGeoHelper = EnviGeoHelper.parse(MAP_INFO, COORD_SYS, PIXEL_SIZE);
        Point2D.Double double_ = enviGeoHelper.pixelToMap(1234.5, 678.25);
        Point2D.Double double_2 = enviGeoHelper.mapToPixel(double_.x, double_.y);
        MatcherAssert.assertThat((Object)double_2.x, (Matcher)Matchers.closeTo((double)1234.5, (double)1.0E-9));
        MatcherAssert.assertThat((Object)double_2.y, (Matcher)Matchers.closeTo((double)678.25, (double)1.0E-9));
    }

    @Test
    public void cropAndHeaders() {
        EnviGeoHelper enviGeoHelper = EnviGeoHelper.parse(MAP_INFO, COORD_SYS, PIXEL_SIZE);
        Point2D.Double double_ = enviGeoHelper.pixelToMap(401.0, 301.0);
        EnviGeoHelper enviGeoHelper2 = enviGeoHelper.forCrop(401, 301);
        Point2D.Double double_2 = enviGeoHelper2.pixelToMap(1.0, 1.0);
        MatcherAssert.assertThat((Object)double_2.x, (Matcher)Matchers.closeTo((double)double_.x, (double)1.0E-9));
        MatcherAssert.assertThat((Object)double_2.y, (Matcher)Matchers.closeTo((double)double_.y, (double)1.0E-9));
        MatcherAssert.assertThat((Object)enviGeoHelper2.getPixelSizeX(), (Matcher)Matchers.closeTo((double)enviGeoHelper.getPixelSizeX(), (double)1.0E-9));
        MatcherAssert.assertThat((Object)enviGeoHelper2.getPixelSizeY(), (Matcher)Matchers.closeTo((double)enviGeoHelper.getPixelSizeY(), (double)1.0E-9));
        MatcherAssert.assertThat((Object)enviGeoHelper2.getCoordinateSystemString(), (Matcher)Matchers.equalTo((Object)enviGeoHelper.getCoordinateSystemString()));
        MatcherAssert.assertThat((Object)enviGeoHelper2.toMapInfoLine(), (Matcher)Matchers.startsWith((String)"UTM, 1, 1,"));
        MatcherAssert.assertThat((Object)enviGeoHelper2.toMapInfoLine(), (Matcher)Matchers.containsString((String)"units=Meter"));
        MatcherAssert.assertThat((Object)enviGeoHelper2.toPixelSizeLine(), (Matcher)Matchers.equalTo((Object)"0.14, 0.14"));
        MatcherAssert.assertThat((Object)enviGeoHelper2.toCoordinateSystemStringLine(), (Matcher)Matchers.startsWith((String)"PROJCS[\"WGS_1984_UTM_Zone_12N\""));
    }

    @Test
    public void mapToPixelKnown() {
        EnviGeoHelper enviGeoHelper = EnviGeoHelper.parse(MAP_INFO, COORD_SYS, PIXEL_SIZE);
        Point2D.Double double_ = enviGeoHelper.mapToPixel(588086.34, 3552004.32);
        MatcherAssert.assertThat((Object)double_.x, (Matcher)Matchers.closeTo((double)11.0, (double)1.0E-9));
        MatcherAssert.assertThat((Object)double_.y, (Matcher)Matchers.closeTo((double)6.0, (double)1.0E-8));
    }

    @Test
    public void parseDummyHeaders() {
        Assert.assertThrows(IllegalArgumentException.class, () -> EnviGeoHelper.parse("1", "2", "3"));
    }

    @Test
    public void parseAndUseUtm54S() {
        EnviGeoHelper enviGeoHelper = EnviGeoHelper.parse("UTM, 1, 1, 396378.160, 7709508.020, 0.0600000, 0.0600000,54,South,WGS-84,units=Meter", "PROJCS[\"WGS_1984_UTM_Zone_54S\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",141.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]", "0.0600000, 0.0600000");
        MatcherAssert.assertThat((Object)enviGeoHelper.getProjectionName(), (Matcher)Matchers.equalTo((Object)"UTM"));
        MatcherAssert.assertThat((Object)enviGeoHelper.getUtmZone(), (Matcher)Matchers.equalTo((Object)54));
        MatcherAssert.assertThat((Object)enviGeoHelper.getHemisphere(), (Matcher)Matchers.equalTo((Object)"South"));
        MatcherAssert.assertThat((Object)enviGeoHelper.getDatum(), (Matcher)Matchers.equalTo((Object)"WGS-84"));
        MatcherAssert.assertThat((Object)enviGeoHelper.getUnits(), (Matcher)Matchers.equalTo((Object)"Meter"));
        MatcherAssert.assertThat((Object)enviGeoHelper.getPixelSizeX(), (Matcher)Matchers.closeTo((double)0.06, (double)1.0E-8));
        MatcherAssert.assertThat((Object)enviGeoHelper.getPixelSizeY(), (Matcher)Matchers.closeTo((double)0.06, (double)1.0E-8));
        MatcherAssert.assertThat((Object)enviGeoHelper.getCoordinateSystemString(), (Matcher)Matchers.startsWith((String)"PROJCS[\"WGS_1984_UTM_Zone_54S\""));
        Point2D.Double double_ = enviGeoHelper.pixelToMap(1.0, 1.0);
        MatcherAssert.assertThat((Object)double_.x, (Matcher)Matchers.closeTo((double)396378.16, (double)1.0E-8));
        MatcherAssert.assertThat((Object)double_.y, (Matcher)Matchers.closeTo((double)7709508.02, (double)1.0E-8));
        Point2D.Double double_2 = enviGeoHelper.pixelToMap(2.0, 1.0);
        MatcherAssert.assertThat((Object)double_2.x, (Matcher)Matchers.closeTo((double)396378.22, (double)1.0E-8));
        MatcherAssert.assertThat((Object)double_2.y, (Matcher)Matchers.closeTo((double)7709508.02, (double)1.0E-8));
        Point2D.Double double_3 = enviGeoHelper.pixelToMap(1.0, 2.0);
        MatcherAssert.assertThat((Object)double_3.x, (Matcher)Matchers.closeTo((double)396378.16, (double)1.0E-8));
        MatcherAssert.assertThat((Object)double_3.y, (Matcher)Matchers.closeTo((double)7709507.96, (double)1.0E-8));
        Point2D.Double double_4 = enviGeoHelper.pixelToMap(123.75, 456.5);
        Point2D.Double double_5 = enviGeoHelper.mapToPixel(double_4.x, double_4.y);
        MatcherAssert.assertThat((Object)double_5.x, (Matcher)Matchers.closeTo((double)123.75, (double)1.0E-8));
        MatcherAssert.assertThat((Object)double_5.y, (Matcher)Matchers.closeTo((double)456.5, (double)1.0E-8));
        EnviGeoHelper enviGeoHelper2 = enviGeoHelper.forCrop(101, 51);
        Point2D.Double double_6 = enviGeoHelper2.pixelToMap(1.0, 1.0);
        MatcherAssert.assertThat((Object)double_6.x, (Matcher)Matchers.closeTo((double)396384.16, (double)1.0E-8));
        MatcherAssert.assertThat((Object)double_6.y, (Matcher)Matchers.closeTo((double)7709505.02, (double)1.0E-8));
        MatcherAssert.assertThat((Object)enviGeoHelper2.getPixelSizeX(), (Matcher)Matchers.closeTo((double)enviGeoHelper.getPixelSizeX(), (double)1.0E-8));
        MatcherAssert.assertThat((Object)enviGeoHelper2.getPixelSizeY(), (Matcher)Matchers.closeTo((double)enviGeoHelper.getPixelSizeY(), (double)1.0E-8));
        MatcherAssert.assertThat((Object)enviGeoHelper2.getCoordinateSystemString(), (Matcher)Matchers.equalTo((Object)enviGeoHelper.getCoordinateSystemString()));
    }

    @Test
    public void resamplePixelSize() {
        EnviGeoHelper enviGeoHelper = EnviGeoHelper.parse("UTM, 1, 1, 588084.940, 3552005.020, 0.140000, 0.140000,12,North,WGS-84,units=Meter", "PROJCS[\"WGS_1984_UTM_Zone_12N\",GEOGCS[\"GCS_WGS_1984\"],UNIT[\"Meter\",1.0]]", "0.140000, 0.140000");
        EnviGeoHelper enviGeoHelper2 = enviGeoHelper.withResampledPixelSize(2.0, 2.0);
        MatcherAssert.assertThat((Object)enviGeoHelper2.getPixelSizeX(), (Matcher)Matchers.closeTo((double)0.28, (double)1.0E-9));
        MatcherAssert.assertThat((Object)enviGeoHelper2.getPixelSizeY(), (Matcher)Matchers.closeTo((double)0.28, (double)1.0E-9));
        Point2D.Double double_ = enviGeoHelper.pixelToMap(1.0, 1.0);
        Point2D.Double double_2 = enviGeoHelper2.pixelToMap(1.0, 1.0);
        MatcherAssert.assertThat((Object)double_2.x, (Matcher)Matchers.closeTo((double)double_.x, (double)1.0E-9));
        MatcherAssert.assertThat((Object)double_2.y, (Matcher)Matchers.closeTo((double)double_.y, (double)1.0E-9));
        MatcherAssert.assertThat((Object)enviGeoHelper2.toPixelSizeLine(), (Matcher)Matchers.is((Object)"0.28, 0.28"));
    }
}

