/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.util.LinkedHashMap;
import java.util.Map;
import se.prediktera.breeze.common.util.raw.EnviGeoHelper;
import se.prediktera.breeze.common.util.raw.RtHdrParser;
import se.prediktera.map.common.error.Logg;

public class ExtraHeaderValues {
    private String type;
    private final LinkedHashMap<String, HeaderEntry> entries = new LinkedHashMap();
    private final Map<String, String> keyIndex = new LinkedHashMap<String, String>();
    private String bandKeyName = "Wavelength";

    public ExtraHeaderValues() {
        this("ENVI");
    }

    public ExtraHeaderValues(String string) {
        this.type = string;
    }

    public ExtraHeaderValues(RtHdrParser rtHdrParser) {
        this("ENVI");
        this.addValues(rtHdrParser);
    }

    public void addValues(RtHdrParser rtHdrParser) {
        this.addIfExists(rtHdrParser, "data ignore value", false);
        this.addIfExists(rtHdrParser, "map info", true);
        this.addIfExists(rtHdrParser, "coordinate system string", true);
        this.addIfExists(rtHdrParser, "pixel size", true);
        this.addIfExists(rtHdrParser, "data gain values", true);
    }

    public void add(String string, String string2, boolean bl) {
        String string3 = string.toLowerCase();
        String string4 = this.keyIndex.get(string3);
        if (string4 != null) {
            this.entries.put(string4, new HeaderEntry(string2, bl));
        } else {
            this.keyIndex.put(string3, string);
            this.entries.put(string, new HeaderEntry(string2, bl));
        }
    }

    public void add(String string, String string2) {
        this.add(string, string2, false);
    }

    public void add(String string) {
        this.add(string, null);
    }

    public boolean hasKey(String string) {
        return this.keyIndex.containsKey(string.toLowerCase());
    }

    public void addIfExists(RtHdrParser rtHdrParser, String string, boolean bl) {
        String string2;
        if (rtHdrParser.contains(string) && (string2 = rtHdrParser.get(string)) != null && !string2.isBlank()) {
            this.add(string, string2, bl);
        }
    }

    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, HeaderEntry> entry : this.entries.entrySet()) {
            HeaderEntry headerEntry = entry.getValue();
            if (headerEntry.value == null || headerEntry.value.isBlank()) continue;
            stringBuilder.append(entry.getKey()).append(" = ");
            if (headerEntry.braces) {
                stringBuilder.append('{').append(headerEntry.value).append('}');
            } else {
                stringBuilder.append(headerEntry.value);
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public boolean hasText() {
        for (HeaderEntry headerEntry : this.entries.values()) {
            if (headerEntry.value == null || headerEntry.value.isBlank()) continue;
            return true;
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setBandKeyName(String string) {
        this.bandKeyName = string;
    }

    public String getBandKeyName() {
        return this.bandKeyName;
    }

    public RtHdrParser updateParserGeoValues(RtHdrParser rtHdrParser, int n, int n2) {
        if ((n > 0 || n2 > 0) && rtHdrParser.contains("map info") && rtHdrParser.contains("coordinate system string") && rtHdrParser.contains("pixel size")) {
            try {
                rtHdrParser = rtHdrParser.clone();
                EnviGeoHelper enviGeoHelper = EnviGeoHelper.parse(rtHdrParser.get("map info"), rtHdrParser.get("coordinate system string"), rtHdrParser.get("pixel size"));
                EnviGeoHelper enviGeoHelper2 = enviGeoHelper.forCrop0Based(n, n2);
                rtHdrParser.set("map info", enviGeoHelper2.toMapInfoLine());
                rtHdrParser.set("coordinate system string", enviGeoHelper2.toCoordinateSystemStringLine());
                rtHdrParser.set("pixel size", enviGeoHelper2.toPixelSizeLine());
            }
            catch (Exception exception) {
                Logg.error((String)"Cannot read map info", (Throwable)exception);
            }
        }
        return rtHdrParser;
    }

    private static final class HeaderEntry {
        final String value;
        final boolean braces;

        HeaderEntry(String string, boolean bl) {
            this.value = string;
            this.braces = bl;
        }
    }
}

