/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.common.util.raw.ExtraHeaderValues;

public class ExtraHeaderValuesTest {
    @Test
    public void testAddAndGetText_NoBraces() {
        ExtraHeaderValues extraHeaderValues = new ExtraHeaderValues();
        extraHeaderValues.add("data ignore value", "-9999");
        String string = extraHeaderValues.getText();
        MatcherAssert.assertThat((Object)extraHeaderValues.hasKey("data ignore value"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)extraHeaderValues.hasText(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)string, (Matcher)CoreMatchers.containsString((String)"data ignore value = -9999"));
    }

    @Test
    public void testAddAndGetText_WithBraces() {
        ExtraHeaderValues extraHeaderValues = new ExtraHeaderValues();
        extraHeaderValues.add("map info", "1, 2, 3", true);
        String string = extraHeaderValues.getText();
        MatcherAssert.assertThat((Object)string, (Matcher)CoreMatchers.containsString((String)"map info = {1, 2, 3}"));
    }

    @Test
    public void testAddKeyWithoutValue_ReservedButNotRendered() {
        ExtraHeaderValues extraHeaderValues = new ExtraHeaderValues();
        extraHeaderValues.add("empty-key");
        MatcherAssert.assertThat((Object)extraHeaderValues.hasKey("empty-key"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)extraHeaderValues.getText(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"empty-key")));
        MatcherAssert.assertThat((Object)extraHeaderValues.hasText(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testOverwriteValue() {
        ExtraHeaderValues extraHeaderValues = new ExtraHeaderValues();
        extraHeaderValues.add("pixel size", "30", true);
        extraHeaderValues.add("pixel size", "60", true);
        String string = extraHeaderValues.getText();
        MatcherAssert.assertThat((Object)string.contains("30"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)string.contains("60"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testEmptyValuesKeptButNotRendered() {
        ExtraHeaderValues extraHeaderValues = new ExtraHeaderValues();
        extraHeaderValues.add("coordinate system string", "UTM", true);
        extraHeaderValues.add("coordinate system string", "");
        MatcherAssert.assertThat((Object)extraHeaderValues.hasKey("coordinate system string"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)extraHeaderValues.getText(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"coordinate system string")));
        MatcherAssert.assertThat((Object)extraHeaderValues.hasText(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testBandKeyNameSetterGetter() {
        ExtraHeaderValues extraHeaderValues = new ExtraHeaderValues();
        extraHeaderValues.setBandKeyName("MyBand");
        MatcherAssert.assertThat((Object)extraHeaderValues.getBandKeyName(), (Matcher)CoreMatchers.is((Object)"MyBand"));
    }
}

