/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.frame.FloatFrame;
import se.prediktera.breeze.common.frame.matrix.ByteFrameMatrix;
import se.prediktera.breeze.common.frame.matrix.FloatFrameMatrix;
import se.prediktera.breeze.common.frame.matrix.ShortFrameMatrix;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.raw.RtHdrParser;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtInterleave;

public class FloatMatrixArrayFromRaw {
    private final FloatMatrix[] matrix;
    private final File rawFile;
    private final RawHeader header;

    public FloatMatrixArrayFromRaw(File file, File file2) {
        this(file, new RawHeader(file2));
    }

    public FloatMatrixArrayFromRaw(File file, RawHeader rawHeader) {
        this.rawFile = file;
        this.header = rawHeader;
        int n = rawHeader.bandCount().value * rawHeader.pixelWidth().value;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            RtHdrParser rtHdrParser;
            FileChannel fileChannel = fileInputStream.getChannel();
            fileChannel.position(rawHeader.getHeaderOffset());
            FrameBuffer frameBuffer = FrameBuffer.getBuffer(n, rawHeader.dataSize(), rawHeader.bandCount(), rawHeader.pixelWidth(), rawHeader.interleave());
            this.matrix = new FloatMatrix[rawHeader.frameCount().value];
            for (int i = 0; i < rawHeader.frameCount().value; ++i) {
                this.matrix[i] = frameBuffer.read(fileChannel);
            }
            String string = rawHeader.getDescription();
            if (string != null && (rtHdrParser = new RtHdrParser(string)).contains("scaling") && rtHdrParser.getValue("scaling") > 1.0) {
                double d = rtHdrParser.getValue("scaling");
                System.out.println("Using scaling " + d + " for file " + file.getName());
                for (FloatMatrix floatMatrix : this.matrix) {
                    for (int i = 0; i < floatMatrix.columns; ++i) {
                        for (int j = 0; j < floatMatrix.rows; ++j) {
                            floatMatrix.put(j, i, (float)((double)floatMatrix.get(j, i) / d));
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public long totalDataSize() {
        long l = 0L;
        for (int i = 0; i < this.matrix.length; ++i) {
            l += (long)(this.matrix[i].length * 4);
        }
        return l;
    }

    public File getRawFile() {
        return this.rawFile;
    }

    public FloatMatrix[] getFrames() {
        return this.matrix;
    }

    public RawHeader getHeader() {
        return this.header;
    }

    private static abstract class FrameBuffer {
        protected final BandCount rows;
        protected final PixelWidth columns;
        protected final RtInterleave interleave;
        protected ByteBuffer byteBuffer;

        protected FrameBuffer(int n, int n2, BandCount bandCount, PixelWidth pixelWidth, RtInterleave rtInterleave) {
            this.rows = bandCount;
            this.columns = pixelWidth;
            this.interleave = rtInterleave;
            this.byteBuffer = ByteBuffer.allocate(n * n2);
        }

        public FloatMatrix read(FileChannel fileChannel) throws IOException {
            fileChannel.read(this.byteBuffer);
            FloatMatrix floatMatrix = this.wrapBufferIntoFrame();
            this.byteBuffer.clear();
            return floatMatrix;
        }

        public abstract FloatMatrix wrapBufferIntoFrame();

        private static FrameBuffer getBuffer(int n, DataSize dataSize, BandCount bandCount, PixelWidth pixelWidth, RtInterleave rtInterleave) {
            return switch (dataSize) {
                default -> throw new MatchException(null, null);
                case DataSize.BYTE_1 -> new FrameByteBuffer(n, dataSize.size, bandCount, pixelWidth, rtInterleave);
                case DataSize.SHORT_2 -> new FrameShortBuffer(n, dataSize.size, bandCount, pixelWidth, rtInterleave);
                case DataSize.FLOAT_4 -> new FrameFloatBuffer(n, dataSize.size, bandCount, pixelWidth, rtInterleave);
                case DataSize.DOUBLE_8 -> new FrameDoubleBuffer(n, dataSize.size, bandCount, pixelWidth, rtInterleave);
            };
        }
    }

    private static class FrameDoubleBuffer
    extends FrameBuffer {
        private final double[] dbuffer;
        private final float[] fbuffer;

        public FrameDoubleBuffer(int n, int n2, BandCount bandCount, PixelWidth pixelWidth, RtInterleave rtInterleave) {
            super(n, n2, bandCount, pixelWidth, rtInterleave);
            this.dbuffer = new double[n];
            this.fbuffer = new float[n];
        }

        @Override
        public FloatMatrix wrapBufferIntoFrame() {
            ByteBuffer.wrap(this.byteBuffer.array()).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer().get(this.dbuffer);
            FloatFrame.convertDoubleToFloatArray(this.dbuffer, this.fbuffer);
            return new FloatFrameMatrix(this.rows, this.columns, this.fbuffer, this.interleave, false);
        }
    }

    private static class FrameFloatBuffer
    extends FrameBuffer {
        private final float[] fbuffer;

        public FrameFloatBuffer(int n, int n2, BandCount bandCount, PixelWidth pixelWidth, RtInterleave rtInterleave) {
            super(n, n2, bandCount, pixelWidth, rtInterleave);
            this.fbuffer = new float[n];
        }

        @Override
        public FloatMatrix wrapBufferIntoFrame() {
            ByteBuffer.wrap(this.byteBuffer.array()).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer().get(this.fbuffer);
            return new FloatFrameMatrix(this.rows, this.columns, this.fbuffer, this.interleave, false);
        }
    }

    private static class FrameShortBuffer
    extends FrameBuffer {
        public FrameShortBuffer(int n, int n2, BandCount bandCount, PixelWidth pixelWidth, RtInterleave rtInterleave) {
            super(n, n2, bandCount, pixelWidth, rtInterleave);
        }

        @Override
        public FloatMatrix wrapBufferIntoFrame() {
            return new ShortFrameMatrix(this.rows, this.columns, this.byteBuffer.array(), this.interleave, false);
        }
    }

    private static class FrameByteBuffer
    extends FrameBuffer {
        private final byte[] bbuffer;

        public FrameByteBuffer(int n, int n2, BandCount bandCount, PixelWidth pixelWidth, RtInterleave rtInterleave) {
            super(n, n2, bandCount, pixelWidth, rtInterleave);
            this.bbuffer = new byte[n];
        }

        @Override
        public FloatMatrix wrapBufferIntoFrame() {
            ByteBuffer.wrap(this.byteBuffer.array()).order(ByteOrder.LITTLE_ENDIAN).get(this.bbuffer);
            return new ByteFrameMatrix(this.rows, this.columns, this.bbuffer, this.interleave, false);
        }
    }
}

