/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.raw.ExtraHeaderValues;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.FrameReader;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawFileWriter;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.raw.RtReferenceTarget;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.util.raw.HySpexHeader;
import se.prediktera.breeze.util.raw.HySpexHelper;

public class FrameCube {
    private final List<RawFrame> frames;
    private final BandCount bands;
    private final PixelWidth width;
    private final FrameCount lines;
    private final DataSize dataSize;
    private RgbBands rgbBands;
    private BandNames bandNames;
    private RtReferenceTarget referenceTarget;
    private MaxSignal maxSignal;
    private String description = "Created by Breeze";
    private ExtraHeaderValues extra;
    private ByteBuffer binaryHeader;

    public FrameCube(File file) {
        RawHeader rawHeader = RawHeader.findByRaw(file);
        this.frames = new FrameListFromRaw(file, rawHeader);
        this.binaryHeader = FrameListFromRaw.readRawHeader(file, rawHeader);
        this.bands = rawHeader.bandCount();
        this.width = rawHeader.pixelWidth();
        this.lines = rawHeader.frameCount();
        this.dataSize = rawHeader.dataSize();
        this.bandNames = rawHeader.bandNames();
        this.rgbBands = rawHeader.rgbBands();
        this.description = rawHeader.getDescription();
    }

    public FrameCube(BandCount bandCount, PixelWidth pixelWidth, FrameCount frameCount, DataSize dataSize) {
        this(bandCount, pixelWidth, frameCount, null, dataSize);
    }

    public FrameCube(BandCount bandCount, PixelWidth pixelWidth, FrameCount frameCount, BandNames bandNames, DataSize dataSize) {
        this.bands = bandCount;
        this.width = pixelWidth;
        this.lines = frameCount;
        this.dataSize = dataSize;
        this.bandNames = bandNames == null ? BandNames.fromIndex(bandCount.value) : bandNames;
        this.frames = new ArrayList<RawFrame>();
        for (int i = 0; i < frameCount.value; ++i) {
            this.frames.add(Frame.createFrame(dataSize, bandCount, pixelWidth, bandNames));
        }
        this.rgbBands = RgbBands.fromBandCount(bandCount);
    }

    public final DataSize getDataSize() {
        return this.dataSize;
    }

    public void setDefaultSpectrum(float[] fArray) {
        for (RawFrame rawFrame : this.frames) {
            for (int i = 0; i < rawFrame.getColumns().value; ++i) {
                for (int j = 0; j < fArray.length; ++j) {
                    rawFrame.setFrameValue(j, i, fArray[j]);
                }
            }
        }
    }

    public void setBandNames(BandNames bandNames) {
        this.bandNames = bandNames;
    }

    public final BandNames getBandNames() {
        return this.bandNames;
    }

    public void setRgbBands(RgbBands rgbBands) {
        this.rgbBands = rgbBands;
    }

    public final RgbBands getRgbBands() {
        return this.rgbBands;
    }

    public final MaxSignal getMaxSignal() {
        if (this.maxSignal == null) {
            this.maxSignal = new MaxSignal(this.frames, this.rgbBands);
        }
        return this.maxSignal;
    }

    public final void setSpectrum(int n, int n2, float[] fArray) {
        RawFrame rawFrame = this.frames.get(n);
        for (int i = 0; i < fArray.length; ++i) {
            rawFrame.setFrameValue(i, n2, fArray[i]);
        }
    }

    public final float[] getSpectrum(int n, int n2) {
        RawFrame rawFrame = this.frames.get(n);
        float[] fArray = new float[this.getBandCount().value];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = rawFrame.getFrameValue(i, n2);
        }
        return fArray;
    }

    public final float getValue(int n, int n2, int n3) {
        return this.frames.get(n).getFrameValue(n2, n3);
    }

    public final void setValue(int n, int n2, int n3, float f) {
        this.frames.get(n).setFrameValue(n2, n3, f);
    }

    public final void setValue(float f) {
        for (RawFrame rawFrame : this.frames) {
            for (int i = 0; i < rawFrame.getColumns().value; ++i) {
                for (int j = 0; j < rawFrame.getRows().value; ++j) {
                    rawFrame.setFrameValue(j, i, f);
                }
            }
        }
    }

    public final List<RawFrame> getFrameList() {
        return this.frames;
    }

    public final FrameReader.RawFrameIterator iterator() {
        return new FrameReader.FrameListIterator(this.frames);
    }

    public final Frame getFrame(int n) {
        return this.frames.get(n);
    }

    public final BandCount getBandCount() {
        return this.bands;
    }

    public final PixelWidth getWidth() {
        return this.width;
    }

    public final FrameCount getLines() {
        return this.lines;
    }

    public final void setReferenceTarget(RtReferenceTarget rtReferenceTarget) {
        this.referenceTarget = rtReferenceTarget;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final void setExtra(ExtraHeaderValues extraHeaderValues) {
        this.extra = extraHeaderValues;
    }

    public final void save(File file) {
        RawHeader rawHeader = new RawHeader(null, this.lines, this.bands, this.width, this.dataSize, this.rgbBands, this.bandNames);
        rawHeader.setReferenceTarget(this.referenceTarget);
        RawFileWriter.writeFramesAndHeader(file, this.frames, rawHeader, this.description, null, this.extra, this.binaryHeader);
    }

    public final boolean inside(int n, int n2) {
        return n >= 0 && n < this.getWidth().value && n2 >= 0 && n2 < this.getLines().value;
    }

    public void subtract(FrameCube frameCube) {
        for (int i = 0; i < this.frames.size(); ++i) {
            RawFrame rawFrame = this.frames.get(i);
            for (int j = 0; j < rawFrame.getColumns().value; ++j) {
                for (int k = 0; k < rawFrame.getRows().value; ++k) {
                    rawFrame.setFrameValue(k, j, rawFrame.getFrameValue(k, j) - frameCube.getValue(i, k, j));
                }
            }
        }
    }

    public void add(FrameCube frameCube) {
        for (int i = 0; i < this.frames.size(); ++i) {
            RawFrame rawFrame = this.frames.get(i);
            for (int j = 0; j < rawFrame.getColumns().value; ++j) {
                for (int k = 0; k < rawFrame.getRows().value; ++k) {
                    rawFrame.setFrameValue(k, j, rawFrame.getFrameValue(k, j) + frameCube.getValue(i, k, j));
                }
            }
        }
    }

    public void div(FrameCube frameCube) {
        for (int i = 0; i < this.frames.size(); ++i) {
            RawFrame rawFrame = this.frames.get(i);
            for (int j = 0; j < rawFrame.getColumns().value; ++j) {
                for (int k = 0; k < rawFrame.getRows().value; ++k) {
                    rawFrame.setFrameValue(k, j, rawFrame.getFrameValue(k, j) / frameCube.getValue(i, k, j));
                }
            }
        }
    }

    public void mult(FrameCube frameCube) {
        for (int i = 0; i < this.frames.size(); ++i) {
            RawFrame rawFrame = this.frames.get(i);
            for (int j = 0; j < rawFrame.getColumns().value; ++j) {
                for (int k = 0; k < rawFrame.getRows().value; ++k) {
                    rawFrame.setFrameValue(k, j, rawFrame.getFrameValue(k, j) * frameCube.getValue(i, k, j));
                }
            }
        }
    }

    public FrameCube toFloat() {
        if (this.dataSize.equals((Object)DataSize.FLOAT_4)) {
            return this;
        }
        FrameCube frameCube = new FrameCube(this.bands, this.width, this.lines, this.bandNames, DataSize.FLOAT_4);
        this.copySettings(frameCube);
        for (int i = 0; i < this.frames.size(); ++i) {
            RawFrame rawFrame = this.frames.get(i);
            for (int j = 0; j < rawFrame.getColumns().value; ++j) {
                for (int k = 0; k < rawFrame.getRows().value; ++k) {
                    frameCube.setValue(i, k, j, rawFrame.getFrameValue(k, j));
                }
            }
        }
        return frameCube;
    }

    private void copySettings(FrameCube frameCube) {
        frameCube.description = this.description;
        frameCube.rgbBands = this.rgbBands;
        frameCube.binaryHeader = this.binaryHeader;
    }

    public FrameCube max() {
        FrameCube frameCube = new FrameCube(new BandCount(1), this.width, this.lines, this.bandNames, this.dataSize);
        for (int i = 0; i < this.frames.size(); ++i) {
            RawFrame rawFrame = this.frames.get(i);
            for (int j = 0; j < rawFrame.getColumns().value; ++j) {
                float f = Float.MIN_VALUE;
                for (int k = 0; k < rawFrame.getRows().value; ++k) {
                    f = Math.max(f, rawFrame.getFrameValue(k, j));
                }
                frameCube.setValue(i, 0, j, f);
            }
        }
        return frameCube;
    }

    public void applyBp() {
        if (this.binaryHeader != null) {
            try {
                HySpexHeader hySpexHeader = new HySpexHeader(this.binaryHeader);
                List<HySpexHelper.BadPixel> list = hySpexHeader.getBadPixelMap();
                for (RawFrame rawFrame : this.frames) {
                    HySpexHeader.applyBadPixels(list, rawFrame);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static class FrameCubeRawFile
    implements RawFile {
        private final FrameCube cube;
        private final RawHeader header;

        public FrameCubeRawFile(FrameCube frameCube) {
            this.cube = frameCube;
            this.header = new RawHeader(frameCube.getLines(), frameCube.bands, frameCube.width, frameCube.dataSize);
            this.header.setBandNames(frameCube.bandNames);
            this.header.setRgbBands(frameCube.getRgbBands());
        }

        @Override
        public RawHeader header() {
            return this.header;
        }

        @Override
        public ByteBuffer readRawHeader() {
            return null;
        }

        @Override
        public List<RawFrame> readFrames() {
            return this.cube.frames;
        }

        @Override
        public File file() {
            return null;
        }
    }
}

