/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.raw.FrameReader;
import se.prediktera.breeze.common.util.raw.RawHeader;

public class FrameListFromRaw
extends ArrayList<RawFrame> {
    private final RawHeader header;

    public FrameListFromRaw(File file, RawHeader rawHeader) {
        this(file, rawHeader, Reduce.Original);
    }

    public FrameListFromRaw(File file) {
        this(file, RawHeader.findByRaw(file));
    }

    public FrameListFromRaw(File file, Reduce reduce) {
        this(file, RawHeader.findByRaw(file), reduce);
    }

    public FrameListFromRaw(File file, RawHeader rawHeader, Reduce reduce) {
        this(file, rawHeader, reduce, null);
    }

    public FrameListFromRaw(File file, RawHeader rawHeader, int[] nArray) {
        this(file, rawHeader, Reduce.Original, nArray);
    }

    public FrameListFromRaw(File file, RawHeader rawHeader, Reduce reduce, int[] nArray) {
        super(FrameListFromRaw.readFramesFromFile(file, rawHeader, reduce, nArray));
        this.header = rawHeader;
    }

    public RawHeader getHeader() {
        return this.header;
    }

    public long totalDataSize() {
        long l = 0L;
        for (int i = 0; i < this.size(); ++i) {
            l += ((RawFrame)this.get(i)).dataSize();
        }
        return l;
    }

    private static List<RawFrame> readFramesFromFile(File file, RawHeader rawHeader, Reduce reduce, int[] nArray) {
        if (!file.exists()) {
            throw new RuntimeException("File does not exist " + String.valueOf(file));
        }
        try (FrameReader.FrameIterator frameIterator = new FrameReader(file, rawHeader, nArray, false, reduce).iterator();){
            ArrayList<RawFrame> arrayList = new ArrayList<RawFrame>();
            while (frameIterator.hasNext()) {
                arrayList.add(frameIterator.next());
            }
            ArrayList<RawFrame> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public static ByteBuffer readRawHeader(File file, RawHeader rawHeader) {
        long l = rawHeader.getHeaderOffset();
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)l);
        if (l > 0L) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                FileChannel fileChannel = fileInputStream.getChannel();
                fileChannel.read(byteBuffer);
                byteBuffer.position(0);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return byteBuffer;
    }

    public static List<Frame> readPartFramesFromFile(File file, RawHeader rawHeader, int n, int n2) {
        if (!file.exists()) {
            throw new RuntimeException("File does not exist " + String.valueOf(file));
        }
        try (FrameReader.FrameIterator frameIterator = new FrameReader(file, rawHeader, null, false, Reduce.Original).iterator();){
            frameIterator.skip(n);
            ArrayList<Frame> arrayList = new ArrayList<Frame>();
            int n3 = n2 - n;
            for (int i = 0; i < n3 && frameIterator.hasNext(); ++i) {
                arrayList.add(frameIterator.next());
            }
            ArrayList<Frame> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public static void forEachFrame(File file, RawHeader rawHeader, FrameCallback frameCallback) {
        if (!file.exists()) {
            throw new RuntimeException("File does not exist " + String.valueOf(file));
        }
        try (FrameReader.FrameIterator frameIterator = new FrameReader(file, rawHeader).iterator();){
            while (frameIterator.hasNext()) {
                frameCallback.onFrame(frameIterator.next());
            }
        }
    }

    public static class Reduce {
        public static Reduce Original = new Reduce(1, 1);
        public final int x;
        public final int y;

        public Reduce(int n) {
            this(n, n);
        }

        public Reduce(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public boolean isReduced() {
            return this.x > 1 || this.y > 1;
        }
    }

    public static interface FrameCallback {
        public void onFrame(Frame var1);
    }
}

