/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.List;
import se.prediktera.breeze.common.frame.ByteFrame;
import se.prediktera.breeze.common.frame.DoubleFrame;
import se.prediktera.breeze.common.frame.FloatFrame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.frame.ShortFrame;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtByteOrder;
import se.prediktera.breeze.common.util.type.RtInterleave;

public class FrameReader
implements Iterable<RawFrame> {
    private final RawHeader header;
    private final File file;
    private final int[] bands;
    private final boolean reuseFrame;
    private final FrameListFromRaw.Reduce reduce;
    private final int pixelStart;
    private final int pixelEnd;

    public FrameReader(RawFile rawFile) {
        this(rawFile.file(), rawFile.header());
    }

    public FrameReader(File file, RawHeader rawHeader) {
        this(file, rawHeader, null, true, FrameListFromRaw.Reduce.Original, 0, rawHeader.pixelWidth().value);
    }

    public FrameReader(File file, RawHeader rawHeader, int[] nArray, boolean bl, FrameListFromRaw.Reduce reduce) {
        this(file, rawHeader, nArray, bl, reduce, 0, rawHeader.pixelWidth().value);
    }

    public FrameReader(File file, RawHeader rawHeader, int[] nArray, boolean bl, FrameListFromRaw.Reduce reduce, int n, int n2) {
        this.file = file;
        this.header = rawHeader;
        this.bands = nArray;
        this.reuseFrame = bl;
        this.reduce = reduce;
        this.pixelStart = n;
        this.pixelEnd = n2;
    }

    public FrameIterator iterator() {
        try {
            return new FrameIterator();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static CopyFrame getCopyFrame(int n, DataSize dataSize) {
        return switch (dataSize) {
            default -> throw new MatchException(null, null);
            case DataSize.BYTE_1 -> new CopyFrameByte();
            case DataSize.SHORT_2 -> new CopyFrameShort();
            case DataSize.FLOAT_4 -> new CopyFrameFloat(n);
            case DataSize.DOUBLE_8 -> new CopyFrameDouble(n);
        };
    }

    public class FrameIterator
    extends RawFrameIterator
    implements Closeable {
        private final FileInputStream fs;
        private final FileChannel channel;
        private final long headerOffset;
        private int bandCountValue;
        private final long frameCountValue;
        private final int subsetWidth;
        private final int lineWidth;
        private final int fileFrameSize;
        private final int bandSize;
        private RawFrame frame;
        private final byte[] dataBuffer;
        private long currentFrameIndex = 0L;
        private final RtInterleave interleave;
        private final RtByteOrder byteOrder;
        private final CopyFrame frameCopy;
        private BandCount bandCount;
        private final DataSize dataSize;
        private final BandNames bandNames;
        private final Double scaling;
        private FloatFrame scalingFrame;
        private final int dataSizeBytes;
        private final int subsetBytes;
        private final int fullLineBytes;
        private final int pixelStrideBIP;
        private long[] bsqOffsets;

        public FrameIterator() throws IOException {
            this.headerOffset = FrameReader.this.header.getHeaderOffset();
            this.fs = new FileInputStream(FrameReader.this.file);
            this.channel = this.fs.getChannel();
            this.channel.position(this.headerOffset);
            this.bandCount = FrameReader.this.header.bandCount();
            this.lineWidth = FrameReader.this.header.pixelWidth().value;
            this.dataSize = FrameReader.this.header.dataSize();
            this.bandNames = FrameReader.this.header.bandNames().fromBands(FrameReader.this.bands);
            this.bandCountValue = this.bandCount.value;
            this.frameCountValue = FrameReader.this.header.frameCount().value;
            this.dataSizeBytes = this.dataSize.size;
            this.subsetWidth = FrameReader.this.pixelEnd - FrameReader.this.pixelStart;
            this.subsetBytes = this.subsetWidth * this.dataSizeBytes;
            this.fullLineBytes = this.lineWidth * this.dataSizeBytes;
            this.interleave = FrameReader.this.header.interleave();
            this.byteOrder = RtByteOrder.fromHeader(FrameReader.this.header.getByteOrder());
            this.fileFrameSize = this.bandCountValue * this.fullLineBytes;
            if (FrameReader.this.bands != null && this.interleave.equals((Object)RtInterleave.BIL)) {
                this.bandCount = new BandCount(FrameReader.this.bands.length);
                this.bandCountValue = FrameReader.this.bands.length;
            }
            this.bandSize = this.fullLineBytes;
            this.pixelStrideBIP = this.dataSizeBytes * this.bandCount.value;
            this.frameCopy = FrameReader.getCopyFrame(this.subsetWidth * this.bandCountValue, this.dataSize);
            this.dataBuffer = new byte[this.subsetBytes * this.bandCountValue];
            this.scaling = FrameReader.this.header.getScaling();
            if (FrameReader.this.reuseFrame) {
                this.frame = RawFrame.createFrame(this.dataSize, new BandCount(this.bandCountValue), new PixelWidth(this.subsetWidth), this.bandNames);
                if (this.scaling != null) {
                    this.scalingFrame = (FloatFrame)RawFrame.createFrame(DataSize.FLOAT_4, new BandCount(this.bandCountValue), new PixelWidth(this.subsetWidth), this.bandNames);
                }
            }
            if (this.interleave.equals((Object)RtInterleave.BSQ)) {
                this.bsqOffsets = new long[this.bandCountValue];
                for (int i = 0; i < this.bandCountValue; ++i) {
                    this.bsqOffsets[i] = this.headerOffset + ((long)i * this.frameCountValue * (long)this.lineWidth + (long)FrameReader.this.pixelStart) * (long)this.dataSizeBytes;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentFrameIndex < this.frameCountValue;
        }

        public void skip() {
            ++this.currentFrameIndex;
        }

        public void skip(int n) {
            this.currentFrameIndex += (long)n;
        }

        @Override
        public RawFrame next() {
            try {
                if (this.currentFrameIndex >= this.frameCountValue) {
                    return null;
                }
                if (!FrameReader.this.reuseFrame) {
                    this.frame = RawFrame.createFrame(this.dataSize, new BandCount(this.bandCountValue), new PixelWidth(this.subsetWidth), this.bandNames);
                }
                if (this.interleave.equals((Object)RtInterleave.BSQ)) {
                    for (int i = 0; i < this.bandCountValue; ++i) {
                        long l = this.bsqOffsets[i] + this.currentFrameIndex * (long)this.lineWidth * (long)this.dataSizeBytes;
                        this.channel.position(l);
                        this.channel.read(ByteBuffer.wrap(this.dataBuffer, i * this.subsetBytes, this.subsetBytes));
                    }
                    this.frameCopy.fromBuffer(this.frame, this.dataBuffer, RtInterleave.BIL, this.byteOrder);
                } else if (this.interleave.equals((Object)RtInterleave.BIL)) {
                    long l = this.headerOffset + this.currentFrameIndex * (long)this.fileFrameSize;
                    if (FrameReader.this.bands == null) {
                        for (var3_7 = 0; var3_7 < this.bandCountValue; ++var3_7) {
                            long l2 = l + (long)(var3_7 * this.bandSize) + (long)(FrameReader.this.pixelStart * this.dataSizeBytes);
                            this.channel.position(l2);
                            this.channel.read(ByteBuffer.wrap(this.dataBuffer, var3_7 * this.subsetBytes, this.subsetBytes));
                        }
                    } else {
                        var3_7 = 0;
                        for (int i = 0; i < FrameReader.this.bands.length; ++i) {
                            int n = FrameReader.this.bands[i];
                            long l3 = l + (long)(n * this.bandSize) + (long)(FrameReader.this.pixelStart * this.dataSizeBytes);
                            if (l3 < 0L) continue;
                            this.channel.position(l3);
                            this.channel.read(ByteBuffer.wrap(this.dataBuffer, var3_7, this.subsetBytes));
                            var3_7 += this.subsetBytes;
                        }
                    }
                    this.frameCopy.fromBuffer(this.frame, this.dataBuffer, this.interleave, this.byteOrder);
                } else if (this.interleave.equals((Object)RtInterleave.BIP)) {
                    long l = this.headerOffset + this.currentFrameIndex * (long)this.fileFrameSize + (long)(FrameReader.this.pixelStart * this.pixelStrideBIP);
                    this.channel.position(l);
                    this.channel.read(ByteBuffer.wrap(this.dataBuffer, 0, this.subsetWidth * this.bandCountValue * this.dataSizeBytes));
                    this.frameCopy.fromBuffer(this.frame, this.dataBuffer, this.interleave, this.byteOrder);
                }
                this.currentFrameIndex += (long)FrameReader.this.reduce.y;
                if (this.scaling != null) {
                    double d = this.scaling;
                    if (!FrameReader.this.reuseFrame) {
                        this.scalingFrame = (FloatFrame)RawFrame.createFrame(DataSize.FLOAT_4, new BandCount(this.bandCountValue), new PixelWidth(this.subsetWidth), this.bandNames);
                    }
                    float[][] fArray = this.scalingFrame.origframe;
                    for (int i = 0; i < this.frame.rows.value; ++i) {
                        float[] fArray2 = fArray[i];
                        for (int j = 0; j < this.frame.columns.value; ++j) {
                            fArray2[j] = (float)((double)this.frame.getFrameValue(i, j) / d);
                        }
                    }
                    return this.scalingFrame;
                }
                return this.frame;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public void close() {
            try {
                this.channel.close();
                this.fs.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    private static class CopyFrameByte
    implements CopyFrame {
        private CopyFrameByte() {
        }

        @Override
        public void fromBuffer(RawFrame rawFrame, byte[] byArray, RtInterleave rtInterleave, RtByteOrder rtByteOrder) {
            ((ByteFrame)rawFrame).copyFromBuffer(byArray, rtInterleave, false, 0);
        }
    }

    private static class CopyFrameShort
    implements CopyFrame {
        private CopyFrameShort() {
        }

        @Override
        public void fromBuffer(RawFrame rawFrame, byte[] byArray, RtInterleave rtInterleave, RtByteOrder rtByteOrder) {
            ((ShortFrame)rawFrame).copyFromBuffer(byArray, rtInterleave, rtByteOrder, false, 0);
        }
    }

    private static class CopyFrameFloat
    implements CopyFrame {
        private final float[] fbuffer;

        public CopyFrameFloat(int n) {
            this.fbuffer = new float[n];
        }

        @Override
        public void fromBuffer(RawFrame rawFrame, byte[] byArray, RtInterleave rtInterleave, RtByteOrder rtByteOrder) {
            ByteBuffer.wrap(byArray).order(rtByteOrder.getNioOrder()).asFloatBuffer().get(this.fbuffer);
            ((FloatFrame)rawFrame).copyFromBuffer(this.fbuffer, rtInterleave, false);
        }
    }

    private static class CopyFrameDouble
    implements CopyFrame {
        private final double[] doubleBuffer;

        public CopyFrameDouble(int n) {
            this.doubleBuffer = new double[n];
        }

        @Override
        public void fromBuffer(RawFrame rawFrame, byte[] byArray, RtInterleave rtInterleave, RtByteOrder rtByteOrder) {
            ByteBuffer.wrap(byArray).order(rtByteOrder.getNioOrder()).asDoubleBuffer().get(this.doubleBuffer);
            ((DoubleFrame)rawFrame).copyFromBuffer(this.doubleBuffer, rtInterleave, false);
        }
    }

    public static class FrameListIterator
    extends RawFrameIterator {
        private final Iterator<RawFrame> iterator;

        public FrameListIterator(List<RawFrame> list) {
            this.iterator = list.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public RawFrame next() {
            return this.iterator.next();
        }
    }

    public static abstract class RawFrameIterator
    implements Iterator<RawFrame> {
        public int size() {
            return 0;
        }
    }

    private static interface CopyFrame {
        public void fromBuffer(RawFrame var1, byte[] var2, RtInterleave var3, RtByteOrder var4);
    }
}

