/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.awt.Rectangle;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.segmentation.SampleImageMask;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.FrameReader;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.PixelWidth;

public class FrameReaderWithBounds
implements Iterable<RawFrame> {
    private final RawHeader header;
    private final File file;
    private final Rectangle bounds;
    private final SampleImageMask imageMask;
    private final int band;
    private final boolean reuseFrame;

    public FrameReaderWithBounds(File file, RawHeader rawHeader, Rectangle rectangle, SampleImageMask sampleImageMask, int n, boolean bl) {
        this.file = file;
        this.header = rawHeader;
        this.bounds = rectangle;
        this.imageMask = sampleImageMask;
        this.band = n;
        this.reuseFrame = bl;
    }

    public FrameIteratorWithBounds iterator() {
        return new FrameIteratorWithBounds();
    }

    public class FrameIteratorWithBounds
    implements Iterator<RawFrame>,
    Closeable {
        private final FrameReader.FrameIterator iterator;
        private RawFrame maskFrame;
        private int frameIndex;
        private BandCount bandCount;
        private final int endIndex;
        private int maskIndex;

        public FrameIteratorWithBounds() {
            int n = FrameReaderWithBounds.this.bounds.x;
            int n2 = FrameReaderWithBounds.this.bounds.x + FrameReaderWithBounds.this.bounds.width;
            this.iterator = new FrameReader(FrameReaderWithBounds.this.file, FrameReaderWithBounds.this.header, null, FrameReaderWithBounds.this.reuseFrame, FrameListFromRaw.Reduce.Original, n, n2).iterator();
            this.frameIndex = FrameReaderWithBounds.this.bounds.y;
            this.iterator.skip(this.frameIndex);
            this.endIndex = this.frameIndex + FrameReaderWithBounds.this.bounds.height;
            this.maskIndex = this.frameIndex * FrameReaderWithBounds.this.header.pixelWidth().value;
        }

        @Override
        public boolean hasNext() {
            return this.frameIndex < this.endIndex && this.iterator.hasNext();
        }

        @Override
        public RawFrame next() {
            RawFrame rawFrame = this.iterator.next();
            if (this.maskFrame == null) {
                this.bandCount = FrameReaderWithBounds.this.band < 0 ? rawFrame.getRows() : new BandCount(1);
                BandNames bandNames = rawFrame.getBandNames();
                this.maskFrame = RawFrame.createFrame(rawFrame.getType(), this.bandCount, new PixelWidth(FrameReaderWithBounds.this.bounds.width), FrameReaderWithBounds.this.band < 0 ? bandNames : new BandNames(bandNames.get(FrameReaderWithBounds.this.band)));
            }
            if (FrameReaderWithBounds.this.imageMask != null) {
                int n = FrameReaderWithBounds.this.imageMask.getWidth();
                int n2 = 0;
                while (n2 < n) {
                    if (FrameReaderWithBounds.this.imageMask.hasData(this.maskIndex)) {
                        if (FrameReaderWithBounds.this.band < 0) {
                            for (int i = 0; i < this.bandCount.value; ++i) {
                                this.maskFrame.setFrameValue(i, n2, rawFrame.getFrameValue(i, n2));
                            }
                        } else {
                            this.maskFrame.setFrameValue(0, n2, rawFrame.getFrameValue(FrameReaderWithBounds.this.band, n2));
                        }
                    }
                    ++n2;
                    ++this.maskIndex;
                }
            } else {
                for (int i = 0; i < FrameReaderWithBounds.this.bounds.width; ++i) {
                    if (FrameReaderWithBounds.this.band < 0) {
                        for (int j = 0; j < this.bandCount.value; ++j) {
                            this.maskFrame.setFrameValue(j, i, rawFrame.getFrameValue(j, i));
                        }
                        continue;
                    }
                    this.maskFrame.setFrameValue(0, i, rawFrame.getFrameValue(FrameReaderWithBounds.this.band, i));
                }
            }
            ++this.frameIndex;
            return this.maskFrame;
        }

        @Override
        public void close() throws IOException {
            this.iterator.close();
        }
    }
}

