/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import se.prediktera.breeze.common.frame.FloatFrame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.raw.FrameListForBand;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.PredictionData;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.entry.measurement.Measurement;

public class PredictionDataCache {
    private static final HashMap<PredictionDataKey, FrameListForBand> predictionDataByBand = new HashMap();
    private static long sizeUsed = 0L;
    private static final long maxSize = 5000000000L;

    public static synchronized PredictionData getPredictionDataLayers(Measurement measurement, int[] nArray) {
        Object object;
        Object object2;
        File file = measurement.getPredictionHdrFile();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n : nArray) {
            PredictionDataKey predictionDataKey = new PredictionDataKey(measurement.getUid(), n);
            if (predictionDataByBand.containsKey(predictionDataKey)) continue;
            arrayList.add(n);
        }
        if (!arrayList.isEmpty()) {
            object2 = new RawHeader(file);
            FrameListFromRaw frameListFromRaw = new FrameListFromRaw(measurement.getPredictionRawFile(), (RawHeader)object2, arrayList.stream().mapToInt(Integer::intValue).toArray());
            long l = frameListFromRaw.totalDataSize();
            if (sizeUsed + l > 5000000000L) {
                PredictionDataCache.clearCache();
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                object = new FrameListForBand();
                Integer n = (Integer)arrayList.get(i);
                for (RawFrame rawFrame : frameListFromRaw) {
                    ((ArrayList)object).add(((FloatFrame)rawFrame).origframe[i]);
                }
                PredictionDataKey predictionDataKey = new PredictionDataKey(measurement.getUid(), n);
                predictionDataByBand.put(predictionDataKey, (FrameListForBand)object);
            }
            sizeUsed += l;
        }
        object2 = new PredictionData();
        for (int n : nArray) {
            object = new PredictionDataKey(measurement.getUid(), n);
            ((PredictionData)object2).put(n, predictionDataByBand.get(object));
        }
        return object2;
    }

    public static synchronized FrameListForBand getPredictionDataLayer(Measurement measurement, int n) {
        File file = measurement.getPredictionHdrFile();
        if (!file.exists()) {
            return null;
        }
        PredictionDataKey predictionDataKey = new PredictionDataKey(measurement.getUid(), n);
        if (predictionDataByBand.get(predictionDataKey) == null) {
            RawHeader rawHeader = new RawHeader(file);
            FrameListFromRaw frameListFromRaw = new FrameListFromRaw(measurement.getPredictionRawFile(), rawHeader, new int[]{n});
            long l = frameListFromRaw.totalDataSize();
            if (sizeUsed + l > 5000000000L) {
                PredictionDataCache.clearCache();
            }
            FrameListForBand frameListForBand = new FrameListForBand();
            for (RawFrame rawFrame : frameListFromRaw) {
                frameListForBand.add(((FloatFrame)rawFrame).origframe[0]);
            }
            sizeUsed += l;
            predictionDataByBand.put(predictionDataKey, frameListForBand);
        }
        return predictionDataByBand.get(predictionDataKey);
    }

    public static synchronized void clearCache() {
        predictionDataByBand.clear();
        sizeUsed = 0L;
    }

    private static class PredictionDataKey {
        public String measurementId;
        public int bandIndex;

        public PredictionDataKey(String string, int n) {
            this.measurementId = string;
            this.bandIndex = n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PredictionDataKey)) {
                return false;
            }
            PredictionDataKey predictionDataKey = (PredictionDataKey)object;
            return this.measurementId.equals(predictionDataKey.measurementId) && this.bandIndex == predictionDataKey.bandIndex;
        }

        public int hashCode() {
            return Objects.hash(this.measurementId, this.bandIndex);
        }
    }
}

