/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.prediktera.breeze.entry.measurement.Measurement;

public final class QgisLauncher {
    private final Path qgisExecutable;
    private final boolean inheritIO;

    private QgisLauncher(Path path, boolean bl) {
        this.qgisExecutable = path;
        this.inheritIO = bl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Result openFiles(List<Path> list) {
        Objects.requireNonNull(list, "rasters");
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No rasters provided.");
        }
        for (Path path : list) {
            QgisLauncher.ensureReadable(path, "Raster");
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.qgisExecutable.toString());
        arrayList.addAll(list.stream().map(Path::toString).toList());
        return this.run(arrayList);
    }

    public Result openProjectWithLayers(Path path, List<Path> list) {
        Objects.requireNonNull(path, "project");
        QgisLauncher.ensureReadable(path, "Project");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.qgisExecutable.toString());
        arrayList.add("--project");
        arrayList.add(path.toString());
        if (list != null && !list.isEmpty()) {
            for (Path path2 : list) {
                QgisLauncher.ensureReadable(path2, "Layer");
            }
            arrayList.addAll(list.stream().map(Path::toString).toList());
        }
        return this.run(arrayList);
    }

    public Result openNewProjectWithLayers(List<Path> list) {
        Objects.requireNonNull(list, "layers");
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No layers provided.");
        }
        for (Path path : list) {
            QgisLauncher.ensureReadable(path, "Layer");
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.qgisExecutable.toString());
        arrayList.addAll(list.stream().map(Path::toString).toList());
        return this.run(arrayList);
    }

    public Result runWithPyQgis(Path path, List<Path> list) {
        Objects.requireNonNull(path, "pythonScript");
        QgisLauncher.ensureReadable(path, "Python script");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.qgisExecutable.toString());
        arrayList.add("--code");
        arrayList.add(path.toString());
        if (list != null && !list.isEmpty()) {
            arrayList.addAll(list.stream().map(Path::toString).toList());
        }
        return this.run(arrayList);
    }

    private Result run(List<String> list) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(list);
            if (this.inheritIO) {
                processBuilder.inheritIO();
            }
            processBuilder.start();
            return new Result(0, "Launched QGIS: " + String.join((CharSequence)" ", list), "");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void openMeasurementsAsLayers(List<Measurement> list) {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (Measurement measurement : list) {
            if (!measurement.hasData() || !measurement.rawFile().header().hasMapInfo()) continue;
            arrayList.add(measurement.rawFile().path());
        }
        this.openNewProjectWithLayers(arrayList);
    }

    private static void ensureReadable(Path path, String string) {
        if (path == null) {
            throw new IllegalArgumentException(string + " path is null.");
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException(string + " does not exist: " + String.valueOf(path));
        }
        if (!Files.isReadable(path)) {
            throw new IllegalArgumentException(string + " is not readable: " + String.valueOf(path));
        }
    }

    private static Path autoDetectQgis() {
        return QgisFinder.find();
    }

    public static boolean isQgisInstalled() {
        try {
            Path path = QgisLauncher.autoDetectQgis();
            return path != null && Files.isExecutable(path);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final class Builder {
        private Path qgisExecutable;
        private boolean inheritIO = false;

        public Builder qgisExecutable(Path path) {
            this.qgisExecutable = path;
            return this;
        }

        public Builder inheritIO(boolean bl) {
            this.inheritIO = bl;
            return this;
        }

        public QgisLauncher build() {
            Path path = this.qgisExecutable != null ? this.qgisExecutable : QgisLauncher.autoDetectQgis();
            return new QgisLauncher(path, this.inheritIO);
        }
    }

    public static final class Result {
        public final int exitCode;
        public final String stdout;
        public final String stderr;

        Result(int n, String string, String string2) {
            this.exitCode = n;
            this.stdout = string;
            this.stderr = string2;
        }

        public String toString() {
            return "QGIS exit=" + this.exitCode + "\n--- stdout ---\n" + this.stdout + "\n--- stderr ---\n" + this.stderr;
        }
    }

    public final class QgisFinder {
        private static final Pattern VERSION_IN_NAME = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.(\\d+))?");
        private static final List<String> QGIS_EXE_NAMES = List.of("qgis-ltr-bin.exe", "qgis-bin.exe", "qgis.exe");

        private QgisFinder(QgisLauncher qgisLauncher) {
        }

        public static Path find() {
            Path path;
            Platform platform = QgisFinder.detectPlatform();
            String string = System.getenv("QGIS_EXE");
            if (string != null && !string.isBlank() && Files.isExecutable(path = Paths.get(string, new String[0]))) {
                return path;
            }
            if (platform == Platform.Windows && (path = QgisFinder.findLatestQgisOnWindows()) != null) {
                return path;
            }
            if (platform == Platform.MacOSX && Files.isExecutable(path = Paths.get("/Applications/QGIS.app/Contents/MacOS/QGIS", new String[0]))) {
                return path;
            }
            if (platform == Platform.Linux) {
                path = Paths.get("/usr/bin/qgis", new String[0]);
                if (Files.isExecutable(path)) {
                    return path;
                }
                Path path2 = Paths.get("/usr/local/bin/qgis", new String[0]);
                if (Files.isExecutable(path2)) {
                    return path2;
                }
            }
            return Paths.get("qgis", new String[0]);
        }

        private static Platform detectPlatform() {
            String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            if (string.contains("win")) {
                return Platform.Windows;
            }
            if (string.contains("mac")) {
                return Platform.MacOSX;
            }
            if (string.contains("nix") || string.contains("nux")) {
                return Platform.Linux;
            }
            return Platform.Other;
        }

        private static Path findLatestQgisOnWindows() {
            Path[] pathArray = new Path[]{Paths.get("C:\\Program Files", new String[0]), Paths.get("C:\\Program Files (x86)", new String[0])};
            ArrayList<QgisCandidate> arrayList = new ArrayList<QgisCandidate>();
            for (Path path : pathArray) {
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, "QGIS*");){
                    for (Path path2 : directoryStream) {
                        int[] nArray;
                        Path path3;
                        if (!Files.isDirectory(path2, new LinkOption[0]) || (path3 = QgisFinder.findQgisExeInDir(path2)) == null) continue;
                        int[] nArray2 = QgisFinder.parseVersionFromFolder(path2.getFileName().toString());
                        if (nArray2 == null) {
                            int[] nArray3 = new int[3];
                            nArray3[0] = -1;
                            nArray3[1] = -1;
                            nArray = nArray3;
                            nArray3[2] = -1;
                        } else {
                            nArray = nArray2;
                        }
                        arrayList.add(new QgisCandidate(path3, nArray));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            arrayList.sort((qgisCandidate, qgisCandidate2) -> {
                boolean bl;
                int n = Integer.compare(qgisCandidate2.v[0], qgisCandidate.v[0]);
                if (n != 0) {
                    return n;
                }
                n = Integer.compare(qgisCandidate2.v[1], qgisCandidate.v[1]);
                if (n != 0) {
                    return n;
                }
                n = Integer.compare(qgisCandidate2.v[2], qgisCandidate.v[2]);
                if (n != 0) {
                    return n;
                }
                boolean bl2 = qgisCandidate.path.toString().contains("Program Files (x86)");
                if (bl2 != (bl = qgisCandidate2.path.toString().contains("Program Files (x86)"))) {
                    return bl2 ? 1 : -1;
                }
                return qgisCandidate.path.toString().compareToIgnoreCase(qgisCandidate2.path.toString());
            });
            return ((QgisCandidate)arrayList.get((int)0)).path;
        }

        private static Path findQgisExeInDir(Path path) {
            Path path2 = path.resolve("bin");
            if (!Files.isDirectory(path2, new LinkOption[0])) {
                return null;
            }
            for (String string : QGIS_EXE_NAMES) {
                Path path3 = path2.resolve(string);
                if (!Files.isExecutable(path3)) continue;
                return path3;
            }
            return null;
        }

        private static int[] parseVersionFromFolder(String string) {
            Matcher matcher = VERSION_IN_NAME.matcher(string);
            if (!matcher.find()) {
                return null;
            }
            try {
                int n = Integer.parseInt(matcher.group(1));
                int n2 = Integer.parseInt(matcher.group(2));
                int n3 = matcher.group(3) == null ? 0 : Integer.parseInt(matcher.group(3));
                return new int[]{n, n2, n3};
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        public static enum Platform {
            Windows,
            MacOSX,
            Linux,
            Other;

        }

        private static final class QgisCandidate {
            final Path path;
            final int[] v;

            QgisCandidate(Path path, int[] nArray) {
                this.path = path;
                this.v = nArray;
            }
        }
    }
}

