/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.List;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.raw.CachedRawFile;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.util.raw.HySpexHeader;

public interface RawFile {
    public RawHeader header();

    public ByteBuffer readRawHeader();

    public List<RawFrame> readFrames();

    public File file();

    public static boolean hasFrames(RawFile rawFile) {
        if (rawFile instanceof CachedRawFile) {
            return ((CachedRawFile)rawFile).hasFrames();
        }
        return true;
    }

    default public boolean isEmpty() {
        return false;
    }

    default public boolean exits() {
        return FileHelper.exists(this.file()) && FileHelper.exists(this.header().file());
    }

    default public Path path() {
        return this.file().toPath();
    }

    default public RtFramePredictor.ReferenceConvertTo getDataFormat() {
        RawHeader.DescriptionData descriptionData;
        if (HySpexHeader.isHySpexFile(this.file())) {
            try {
                return new HySpexHeader(this.file()).getDataFormat();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((descriptionData = this.header().getDescriptionData()) != null && descriptionData.dataFormat != null) {
            return descriptionData.dataFormat;
        }
        return RtFramePredictor.ReferenceConvertTo.None;
    }

    public static boolean exists(RawFile rawFile) {
        return rawFile != null && rawFile.exits();
    }
}

