/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.io.File;
import java.nio.ByteBuffer;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.raw.ExtraHeaderValues;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.FrameReader;
import se.prediktera.breeze.common.util.raw.RawFileFrameWriter;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.RtInterleave;

public class RawFileConverter {
    public static void convertToBil(BreezeProgress breezeProgress, File file) {
        RawFileConverter.convertToBil(breezeProgress, file, file);
    }

    public static void convertToBil(BreezeProgress breezeProgress, File file, File file2) {
        RawHeader rawHeader = RawHeader.findByRaw(file);
        breezeProgress.setInfoText("Converting data to BIL");
        breezeProgress.setMaximumAndReset(rawHeader.frameCount().value);
        File file3 = FileHelper.createTempFileInWorkspace("raw");
        ByteBuffer byteBuffer = FrameListFromRaw.readRawHeader(file, rawHeader);
        boolean bl = rawHeader.hasScaling();
        DataSize dataSize = bl ? DataSize.FLOAT_4 : rawHeader.dataSize();
        try (RawFileFrameWriter rawFileFrameWriter = new RawFileFrameWriter(file3, rawHeader.bandCount(), rawHeader.pixelWidth(), dataSize);
             FrameReader.FrameIterator frameIterator = new FrameReader(file, rawHeader).iterator();){
            if (byteBuffer != null) {
                rawFileFrameWriter.writeHeader(byteBuffer);
            }
            while (frameIterator.hasNext()) {
                rawFileFrameWriter.writeFrame(frameIterator.next());
                breezeProgress.incStep();
            }
        }
        FileHelper.moveFile(file3, file2);
        rawHeader.setInterleave(RtInterleave.BIL);
        rawHeader.setFile(new File(file2.getParentFile(), FileHelper.getFileName(file2) + ".hdr"));
        rawHeader.setDataSize(dataSize);
        rawHeader.save(new ExtraHeaderValues(rawHeader.getParser()));
    }

    public static boolean shouldConvert(RawHeader rawHeader) {
        if (!rawHeader.interleave().equals((Object)RtInterleave.BIL)) {
            return true;
        }
        return rawHeader.hasScaling();
    }
}

