/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Collection;
import se.prediktera.breeze.common.frame.DoubleFrame;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.frame.FramePool;
import se.prediktera.breeze.common.util.thread.BreezeThread;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.hardware.Camera;

public class RawFileFrameWriter
implements AutoCloseable {
    private final DataSize dataSize;
    private int lineCount = 0;
    private final FileOutputStream out;
    protected FileChannel fileChannel;
    protected ByteBuffer byteBuffer;
    private final Rectangle boundingBox;

    public RawFileFrameWriter(File file, BandCount bandCount, PixelWidth pixelWidth, DataSize dataSize) {
        this(file, bandCount, pixelWidth, dataSize, null);
    }

    public RawFileFrameWriter(File file, BandCount bandCount, PixelWidth pixelWidth, DataSize dataSize, Rectangle rectangle) {
        this.dataSize = dataSize;
        this.boundingBox = rectangle;
        file.getParentFile().mkdirs();
        try {
            this.out = new FileOutputStream(file);
            this.fileChannel = this.out.getChannel();
            this.byteBuffer = rectangle != null ? ByteBuffer.allocate(rectangle.width * bandCount.value * dataSize.size) : ByteBuffer.allocate(pixelWidth.value * bandCount.value * dataSize.size);
            this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
    }

    public void writeHeader(ByteBuffer byteBuffer) {
        if (byteBuffer.capacity() > 0) {
            try {
                byteBuffer.position(0);
                this.fileChannel.write(byteBuffer);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public void writeFrames(Collection<? extends Frame> collection) {
        for (Frame frame : collection) {
            this.writeFrame(frame);
        }
    }

    public void writeFrame(Frame frame) {
        int n = 0;
        int n2 = frame.getColumns().value;
        if (this.boundingBox != null) {
            n = this.boundingBox.x;
            n2 = n + this.boundingBox.width;
        }
        if (frame instanceof DoubleFrame) {
            DoubleFrame doubleFrame = (DoubleFrame)frame;
            for (int i = 0; i < frame.getRows().value; ++i) {
                for (int j = n; j < n2; ++j) {
                    this.byteBuffer.putDouble(doubleFrame.getFrameValueNative(i, j));
                }
            }
        } else {
            for (int i = 0; i < frame.getRows().value; ++i) {
                for (int j = n; j < n2; ++j) {
                    if (this.dataSize == DataSize.BYTE_1) {
                        this.byteBuffer.put((byte)frame.getFrameValue(i, j));
                        continue;
                    }
                    if (this.dataSize == DataSize.SHORT_2) {
                        this.byteBuffer.putShort((short)frame.getFrameValue(i, j));
                        continue;
                    }
                    if (this.dataSize != DataSize.FLOAT_4) continue;
                    this.byteBuffer.putFloat(frame.getFrameValue(i, j));
                }
            }
        }
        if (!this.byteBuffer.hasRemaining()) {
            this.writeBufferAndIncreaseLineCount();
        }
    }

    @Override
    public void close() {
        try {
            this.fileChannel.close();
            this.out.close();
            this.byteBuffer.clear();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public FrameCount lineCount() {
        return new FrameCount(this.lineCount);
    }

    private void writeBufferAndIncreaseLineCount() {
        try {
            this.byteBuffer.position(0);
            this.fileChannel.write(this.byteBuffer);
            this.byteBuffer.clear();
            ++this.lineCount;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static class Live {
        private final File file;
        private final RawFileFrameWriter writer;
        private final FramePool framePool;
        private final FramePool frameQueue;
        private boolean saving = true;

        public Live(Camera camera, File file) {
            this(file, camera.getBandCount(), camera.getWidth(), camera.getBandNames(), camera.getDataSize());
        }

        public Live(File file, BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, DataSize dataSize) {
            this.file = file;
            this.writer = new RawFileFrameWriter(file, bandCount, pixelWidth, dataSize, null);
            this.framePool = new FramePool(bandCount, pixelWidth, bandNames, dataSize);
            this.frameQueue = new FramePool(bandCount, pixelWidth, bandNames, dataSize, 0);
            new BreezeThread("Live.Raw"){

                @Override
                public void run() {
                    block4: {
                        try {
                            while (saving) {
                                RawFrame rawFrame = frameQueue.poll();
                                if (rawFrame != null) {
                                    writer.writeFrame(rawFrame);
                                    framePool.returnFrame(rawFrame);
                                    continue;
                                }
                                ThreadUtil.sleep(10L);
                            }
                        }
                        catch (Exception exception) {
                            if (!saving) break block4;
                            throw exception;
                        }
                    }
                }
            }.start();
        }

        public File getFile() {
            return this.file;
        }

        public BandCount getBandCount() {
            return this.framePool.getFrameRows();
        }

        public PixelWidth getPixelWidth() {
            return this.framePool.getFrameColumns();
        }

        public DataSize getDataSize() {
            return this.framePool.getDataSize();
        }

        public RawFrame getFrameFromPool() {
            return this.framePool.getFrame();
        }

        public void addFrameToQueue(RawFrame rawFrame) {
            this.frameQueue.returnFrame(rawFrame);
        }

        public FrameCount finish() {
            ThreadUtil.awaitOrThrow(() -> this.frameQueue.isEmpty());
            this.close();
            return new FrameCount(this.writer.lineCount);
        }

        public void close() {
            if (this.saving) {
                this.frameQueue.clear();
                this.saving = false;
                this.writer.close();
            }
        }
    }
}

