/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.raw.ExtraHeaderValues;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.raw.RtReferenceTarget;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.HdrByteOrder;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.common.util.type.RtInterleave;

public class RawFileHeaderWriter {
    private final SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");

    public void writeHeader(RawHeader rawHeader, ExtraHeaderValues extraHeaderValues) {
        this.writeHeader(rawHeader.file(), rawHeader.bandCount(), rawHeader.pixelWidth(), rawHeader.bandNames(), rawHeader.dataSize(), rawHeader.rgbBands(), rawHeader.frameCount(), rawHeader.interleave(), rawHeader.getByteOrder(), rawHeader.getDescription(), rawHeader.getReferenceTarget(), 0L, rawHeader.getXstart(), rawHeader.getYstart(), extraHeaderValues);
    }

    public void writeHeader(File file, BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, DataSize dataSize, RgbBands rgbBands, FrameCount frameCount, RtInterleave rtInterleave, HdrByteOrder hdrByteOrder, String string) {
        this.writeHeader(file, bandCount, pixelWidth, bandNames, dataSize, rgbBands, frameCount, rtInterleave, hdrByteOrder, string, null, 0L, 0, 0, null);
    }

    public void writeHeader(File file, BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, DataSize dataSize, RgbBands rgbBands, FrameCount frameCount, RtInterleave rtInterleave, HdrByteOrder hdrByteOrder, String string, RtReferenceTarget rtReferenceTarget, long l, int n, int n2, ExtraHeaderValues extraHeaderValues) {
        FileHelper.mkdirs(file);
        try (FileWriter fileWriter = new FileWriter(file);
             WriteLineBufferedWriter writeLineBufferedWriter = new WriteLineBufferedWriter(this, fileWriter);){
            writeLineBufferedWriter.writeLine("ENVI");
            if (string != null) {
                writeLineBufferedWriter.writeLine("description = { " + string + " }");
            } else {
                writeLineBufferedWriter.writeLine("description = {}");
            }
            if (extraHeaderValues != null) {
                writeLineBufferedWriter.writeLine("file type = " + extraHeaderValues.getType());
            } else {
                writeLineBufferedWriter.writeLine("file type = ENVI");
            }
            writeLineBufferedWriter.writeLine("date = " + this.getTimestamp());
            writeLineBufferedWriter.newLine();
            writeLineBufferedWriter.writeLine("interleave = " + rtInterleave.name());
            writeLineBufferedWriter.writeLine("samples = " + pixelWidth.value);
            writeLineBufferedWriter.writeLine("lines   = " + frameCount.value);
            writeLineBufferedWriter.writeLine("bands   = " + bandCount.value);
            if (rgbBands != null) {
                writeLineBufferedWriter.writeLine(rgbBands.toEnviHdrString());
            }
            writeLineBufferedWriter.writeLine("header offset = " + l);
            writeLineBufferedWriter.writeLine("data type = %d", dataSize.toHdrDataType());
            writeLineBufferedWriter.writeLine("byte order = " + hdrByteOrder.getOrder());
            writeLineBufferedWriter.newLine();
            writeLineBufferedWriter.writeLine("x start = " + n);
            writeLineBufferedWriter.writeLine("y start = " + n2);
            writeLineBufferedWriter.writeLine("errors = {none}");
            writeLineBufferedWriter.newLine();
            if (extraHeaderValues != null && extraHeaderValues.hasText()) {
                writeLineBufferedWriter.writeLine(extraHeaderValues.getText());
            }
            if (bandNames != null) {
                if (extraHeaderValues != null) {
                    writeLineBufferedWriter.writeLine(bandNames.toEnviHdrString(extraHeaderValues.getBandKeyName()));
                } else {
                    writeLineBufferedWriter.writeLine(bandNames.toEnviHdrString());
                }
            }
            if (rtReferenceTarget != null) {
                writeLineBufferedWriter.newLine();
                writeLineBufferedWriter.writeLine(rtReferenceTarget.toEnviHdrString());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected String getTimestamp() {
        return this.format.format(new Date());
    }

    private class WriteLineBufferedWriter
    extends BufferedWriter {
        public WriteLineBufferedWriter(RawFileHeaderWriter rawFileHeaderWriter, Writer writer) {
            super(writer);
        }

        public void writeLine(String string) {
            try {
                this.write(string);
                this.newLine();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public void writeLine(String string, Object object) {
            this.writeLine(String.format(string, object));
        }
    }
}

