/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.io.File;
import java.nio.ByteBuffer;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawFileWriter;
import se.prediktera.breeze.common.util.raw.RawHeader;

public class RawFileImpl
implements RawFile {
    private final File rawFile;
    private final RawHeader header;
    private FrameListFromRaw frames;

    public RawFileImpl(File file) {
        this(file, RawHeader.findHeaderFileByRaw(file));
    }

    public RawFileImpl(File file, File file2) {
        this.rawFile = file;
        this.header = new RawHeader(file2);
    }

    @Override
    public RawHeader header() {
        return this.header;
    }

    public FrameListFromRaw readFrames() {
        if (this.frames == null) {
            this.frames = new FrameListFromRaw(this.file(), this.header());
            return this.frames;
        }
        return this.frames;
    }

    @Override
    public ByteBuffer readRawHeader() {
        return FrameListFromRaw.readRawHeader(this.file(), this.header());
    }

    @Override
    public File file() {
        return this.rawFile;
    }

    public void save(File file) {
        RawFileWriter.writeFramesAndHeader(file, this.readFrames(), this.header(), "");
    }

    public String toString() {
        return this.rawFile.toString();
    }
}

