/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.awt.Rectangle;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.util.raw.ExtraHeaderValues;
import se.prediktera.breeze.common.util.raw.RawFileFrameWriter;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;

public class RawFileWriter {
    public static File writeFramesAndHeader(File file, String string, List<? extends Frame> list) {
        return RawFileWriter.writeFramesAndHeader(file, string, list, null, "", null);
    }

    public static File writeFramesAndHeader(File file, String string, List<? extends Frame> list, BandNames bandNames, String string2, ExtraHeaderValues extraHeaderValues) {
        if (list.size() == 0) {
            throw new RuntimeException("Cant write empty raw file");
        }
        File file2 = new File(file, string + ".hdr");
        File file3 = new File(file, string + ".raw");
        if (bandNames == null) {
            bandNames = BandNames.fromIndex(list.get((int)0).rows.value);
        }
        RawHeader rawHeader = new RawHeader(file2, new FrameCount(list.size()), list.get((int)0).rows, list.get((int)0).columns, list.get(0).getType(), list.get((int)0).rows.getRgbBands(bandNames), bandNames);
        RawFileWriter.writeFramesAndHeader(file3, list, rawHeader, string2, null, extraHeaderValues);
        return file3;
    }

    public static void writeFramesAndHeader(File file, List<? extends Frame> list, RawHeader rawHeader, String string) {
        RawFileWriter.writeFramesAndHeader(file, list, rawHeader, string, null, null);
    }

    public static void writeFramesAndHeader(File file, List<? extends Frame> list, RawHeader rawHeader, String string, Rectangle rectangle, ExtraHeaderValues extraHeaderValues) {
        RawFileWriter.writeFramesAndHeader(file, list, rawHeader, string, rectangle, extraHeaderValues, null);
    }

    public static void writeFramesAndHeader(File file, List<? extends Frame> list, RawHeader rawHeader, String string, Rectangle rectangle, ExtraHeaderValues extraHeaderValues, ByteBuffer byteBuffer) {
        if (list.size() == 0) {
            throw new RuntimeException("Cant write empty raw file");
        }
        BandCount bandCount = list.get(0).getRows();
        PixelWidth pixelWidth = rectangle != null ? new PixelWidth(rectangle.width) : list.get(0).getColumns();
        try (RawFileFrameWriter rawFileFrameWriter = new RawFileFrameWriter(file, bandCount, pixelWidth, rawHeader.dataSize(), rectangle);){
            int n = 0;
            if (byteBuffer != null) {
                rawFileFrameWriter.writeHeader(byteBuffer);
                n = byteBuffer.limit();
            }
            rawFileFrameWriter.writeFrames(list);
            rawHeader.writeByRaw(file, bandCount, pixelWidth, rawFileFrameWriter.lineCount(), string, extraHeaderValues, n);
        }
    }
}

