/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Locale;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.measure.ReferenceStatus;
import se.prediktera.breeze.common.util.raw.ExtraHeaderValues;
import se.prediktera.breeze.common.util.raw.RawFileHeaderWriter;
import se.prediktera.breeze.common.util.raw.RtHdrDataType;
import se.prediktera.breeze.common.util.raw.RtHdrParser;
import se.prediktera.breeze.common.util.raw.RtReferenceTarget;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.HdrByteOrder;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.common.util.type.RtInterleave;
import se.prediktera.breeze.common.util.type.Temperature;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.util.raw.HySpexHeader;
import se.prediktera.map.common.error.Logg;

public class RawHeader {
    private File file;
    private boolean needsRead = false;
    private FrameCount frameCount;
    private BandCount bandCount;
    private PixelWidth pixelWidth;
    private RgbBands rgbBands;
    private RtInterleave interleave = RtInterleave.BIL;
    private BandNames bandNames;
    private DataSize dataSize;
    private String description;
    private HdrByteOrder byteOrder = HdrByteOrder.Default();
    private long headerOffset = 0L;
    private RtReferenceTarget referenceTarget;
    private String[] mapInfo;
    private RtHdrParser parser;
    private int xStart;
    private int yStart;
    private BandNames spectraNames;
    private float[] dataGainValues;

    public RawHeader(FrameCount frameCount, BandCount bandCount, PixelWidth pixelWidth) {
        this(frameCount, bandCount, pixelWidth, DataSize.SHORT_2);
    }

    public RawHeader(FrameCount frameCount, BandCount bandCount, PixelWidth pixelWidth, DataSize dataSize) {
        this(null, frameCount, bandCount, pixelWidth, dataSize, null, null);
    }

    public RawHeader(File file, FrameCount frameCount, BandCount bandCount, PixelWidth pixelWidth, DataSize dataSize, RgbBands rgbBands, BandNames bandNames) {
        this.file = file;
        this.frameCount = frameCount;
        this.bandCount = bandCount;
        this.pixelWidth = pixelWidth;
        this.dataSize = dataSize;
        this.rgbBands = rgbBands;
        this.bandNames = bandNames;
    }

    public RawHeader(Camera camera) {
        this.bandCount = camera.getBandCount();
        this.pixelWidth = camera.getWidth();
        this.rgbBands = camera.getRgbBands();
        this.bandNames = camera.getBandNames();
        this.dataSize = camera.getDataSize();
    }

    public RawHeader(File file) {
        this.file = file;
        this.needsRead = true;
    }

    public RawHeader() {
        this.needsRead = false;
    }

    public RawHeader(HySpexHeader hySpexHeader) {
        this.frameCount = new FrameCount(hySpexHeader.numberOfFrames);
        this.bandCount = new BandCount(hySpexHeader.spectralSize);
        this.pixelWidth = new PixelWidth(hySpexHeader.spatialSize);
        this.dataSize = DataSize.FLOAT_4;
        this.rgbBands = new RgbBands(hySpexHeader.defaultR, hySpexHeader.defaultG, hySpexHeader.defaultB);
        this.bandNames = hySpexHeader.getBandNames();
    }

    public void setNeedsRead(boolean bl) {
        this.needsRead = bl;
    }

    public void setReducedSize(FrameCount frameCount, PixelWidth pixelWidth) {
        this.readIfNeeded();
        this.frameCount = frameCount;
        this.pixelWidth = pixelWidth;
    }

    public void setDataSize(DataSize dataSize) {
        this.readIfNeeded();
        this.dataSize = dataSize;
    }

    public DataSize dataSize() {
        this.readIfNeeded();
        return this.dataSize;
    }

    public void setPixelWidth(PixelWidth pixelWidth) {
        this.readIfNeeded();
        this.pixelWidth = pixelWidth;
    }

    public PixelWidth pixelWidth() {
        this.readIfNeeded();
        return this.pixelWidth;
    }

    public void setFrameCount(FrameCount frameCount) {
        this.readIfNeeded();
        this.frameCount = frameCount;
    }

    public FrameCount frameCount() {
        this.readIfNeeded();
        return this.frameCount;
    }

    public void setInterleave(RtInterleave rtInterleave) {
        this.readIfNeeded();
        this.interleave = rtInterleave;
    }

    public RtInterleave interleave() {
        this.readIfNeeded();
        return this.interleave;
    }

    public BandCount bandCount() {
        this.readIfNeeded();
        return this.bandCount;
    }

    public BandNames bandNames() {
        this.readIfNeeded();
        return this.bandNames;
    }

    public int getTotalSize() {
        this.readIfNeeded();
        return this.pixelWidth.value * this.frameCount.value * this.bandCount.value;
    }

    public BandNames spectraNames() {
        this.readIfNeeded();
        return this.spectraNames;
    }

    public float[] dataGainValues() {
        this.readIfNeeded();
        return this.dataGainValues;
    }

    public void setBandNames(BandNames bandNames) {
        this.bandNames = bandNames;
    }

    public RgbBands rgbBands() {
        this.readIfNeeded();
        return this.rgbBands;
    }

    public void setRgbBands(RgbBands rgbBands) {
        this.rgbBands = rgbBands;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        this.readIfNeeded();
        return this.description;
    }

    public long getHeaderOffset() {
        this.readIfNeeded();
        return this.headerOffset;
    }

    public void setHeaderOffset(long l) {
        this.readIfNeeded();
        this.headerOffset = l;
    }

    public HdrByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setReferenceTarget(RtReferenceTarget rtReferenceTarget) {
        this.referenceTarget = rtReferenceTarget;
    }

    public RtReferenceTarget getReferenceTarget() {
        this.readIfNeeded();
        return this.referenceTarget;
    }

    public String[] getMapInfo() {
        this.readIfNeeded();
        return this.mapInfo;
    }

    public boolean hasMapInfo() {
        String[] stringArray = this.getMapInfo();
        if (stringArray != null) {
            return stringArray.length > 0;
        }
        return false;
    }

    public File file() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public int getXstart() {
        this.readIfNeeded();
        return this.xStart;
    }

    public void setxStart(int n) {
        this.xStart = n;
    }

    public int getYstart() {
        this.readIfNeeded();
        return this.yStart;
    }

    public void setyStart(int n) {
        this.yStart = n;
    }

    public void writeByRaw(File file, BandCount bandCount, PixelWidth pixelWidth, FrameCount frameCount, String string, ExtraHeaderValues extraHeaderValues, long l) {
        File file2 = RawHeader.findHeaderFileByRaw(file);
        new RawFileHeaderWriter().writeHeader(file2, bandCount, pixelWidth, this.bandNames, this.dataSize, this.rgbBands, frameCount, this.interleave, this.byteOrder, string, this.referenceTarget, l, this.xStart, this.yStart, extraHeaderValues);
        this.bandCount = bandCount;
        this.pixelWidth = pixelWidth;
        this.frameCount = frameCount;
    }

    public void save() {
        this.save(null);
    }

    public void save(ExtraHeaderValues extraHeaderValues) {
        new RawFileHeaderWriter().writeHeader(this.file(), this.bandCount(), this.pixelWidth(), this.bandNames(), this.dataSize(), this.rgbBands(), this.frameCount(), this.interleave(), this.getByteOrder(), this.getDescription(), this.getReferenceTarget(), this.getHeaderOffset(), this.getXstart(), this.getYstart(), extraHeaderValues);
    }

    public static RawHeader findByRaw(File file) {
        return new RawHeader(RawHeader.findHeaderFileByRaw(file));
    }

    public static File findHeaderFileByRaw(File file) {
        if (file != null) {
            File file2;
            File file3 = RawHeader.getHeaderFileByRaw(file);
            if (!file3.exists() && (file2 = new File(file.getParentFile(), file.getName() + ".hdr")).exists()) {
                return file2;
            }
            return file3;
        }
        return null;
    }

    public static File getHeaderFileByRaw(File file) {
        return new File(file.getParentFile(), FileHelper.getFileName(file) + ".hdr");
    }

    public static File findRawFileByHeader(File file) {
        String[] stringArray;
        for (String string : stringArray = new String[]{".raw", ""}) {
            File file2 = new File(file.getParentFile(), FileHelper.getFileName(file) + string);
            if (!file2.exists()) continue;
            return file2;
        }
        return null;
    }

    protected RtHdrParser createParser() throws IOException {
        return new RtHdrParser(this.file);
    }

    public RtHdrParser getParser() {
        this.readIfNeeded();
        if (this.parser == null) {
            this.parser = new RtHdrParser();
        }
        return this.parser;
    }

    public void reload() {
        this.needsRead = true;
        this.readIfNeeded();
    }

    public void readIfNeeded() {
        if (this.needsRead) {
            try {
                this.parser = this.createParser();
                this.frameCount = new FrameCount(this.parser.getInt("lines"));
                this.bandCount = new BandCount(this.parser.getInt("bands"));
                this.pixelWidth = new PixelWidth(this.parser.getInt("samples"));
                this.rgbBands = RgbBands.fromEvinceDefaultBands(this.parser.getIntArray("default bands"));
                this.interleave = RtInterleave.parse(this.parser.get("interleave"));
                if (this.parser.contains("wavelength")) {
                    this.bandNames = BandNames.fromEvinceLayerNames(this.parser.getArray("wavelength"));
                } else if (this.parser.contains("band names")) {
                    this.bandNames = BandNames.fromEvinceLayerNames(this.parser.getArray("band names"));
                }
                if (this.bandNames == null) {
                    this.bandNames = BandNames.fromIndex(this.bandCount.value);
                }
                if (this.rgbBands == null) {
                    this.rgbBands = RgbBands.fromBandCount(this.bandCount, this.bandNames);
                }
                if (this.parser.contains("spectra names")) {
                    this.spectraNames = BandNames.fromEvinceLayerNames(this.parser.getArray("spectra names"));
                }
                if (this.parser.contains("data gain values")) {
                    this.dataGainValues = this.parser.getFloatArray("data gain values");
                }
                this.dataSize = DataSize.fromEvinceDataSize(new RtHdrDataType(this.parser.getInt("data type")).getSampleSize());
                this.description = this.parser.get("description");
                if (this.parser.contains("header offset")) {
                    this.headerOffset = this.parser.getLong("header offset");
                }
                if (this.parser.contains("byte order")) {
                    this.byteOrder = new HdrByteOrder(this.parser.getInt("byte order"));
                }
                if (this.parser.contains("x start")) {
                    this.xStart = this.parser.getInt("x start");
                }
                if (this.parser.contains("y start")) {
                    this.yStart = this.parser.getInt("y start");
                }
                this.referenceTarget = RtReferenceTarget.fromHdr(this.parser.getFloatArray("reference target"));
                this.mapInfo = this.parser.getArray("map info");
                this.needsRead = false;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public DescriptionData getDescriptionData() {
        String string = this.getDescription();
        if (string == null) {
            return null;
        }
        RtHdrParser rtHdrParser = new RtHdrParser(string);
        return new DescriptionData(rtHdrParser);
    }

    public boolean hasScaling() {
        Double d = this.getScaling();
        return d != null && d != 1.0;
    }

    public Double getScaling() {
        RtHdrParser rtHdrParser;
        String string = this.getDescription();
        if (string != null && (rtHdrParser = new RtHdrParser(string)).contains("scaling")) {
            return rtHdrParser.getValue("scaling");
        }
        return null;
    }

    public static class DescriptionData {
        private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 1, 4, false).toFormatter(Locale.ROOT);
        public String cameraName;
        public String cameraType;
        public int cameraId;
        public IntegrationTime integrationTime;
        public Temperature temperature;
        public File origFile;
        public String date;
        public RtFramePredictor.ReferenceConvertTo dataFormat = RtFramePredictor.ReferenceConvertTo.None;
        private final RtHdrParser parser;

        public DescriptionData() {
            this.parser = null;
        }

        public DescriptionData(RtHdrParser rtHdrParser) {
            this.parser = rtHdrParser;
            try {
                if (rtHdrParser.contains("prediktera - breeze runtime")) {
                    this.cameraName = rtHdrParser.get("camera name");
                    this.cameraType = rtHdrParser.get("camera type");
                    if (rtHdrParser.contains("camera id")) {
                        this.cameraId = rtHdrParser.getInt("camera id");
                    }
                    if (rtHdrParser.contains("temperature")) {
                        this.temperature = new Temperature(rtHdrParser.getFloat("temperature"));
                    }
                    if (rtHdrParser.contains("date")) {
                        this.date = rtHdrParser.get("date");
                    }
                }
                if (rtHdrParser.contains("integration time")) {
                    this.integrationTime = new IntegrationTime(rtHdrParser.getFloat("integration time"));
                }
                if (rtHdrParser.contains("origfile")) {
                    this.origFile = new File(rtHdrParser.get("origfile").trim());
                }
                this.dataFormat = RtFramePredictor.ReferenceConvertTo.parse(rtHdrParser.get("data format"), RtFramePredictor.ReferenceConvertTo.None);
            }
            catch (Exception exception) {
                Logg.error((String)"Cannot parse description data", (Throwable)exception);
            }
        }

        public RtHdrParser getParser() {
            return this.parser;
        }

        public ReferenceStatus getReferenceStatus(boolean bl) {
            return new ReferenceStatus(this.parser.getHeader(), bl);
        }

        public Date getDate() {
            if (this.date != null) {
                try {
                    String string = this.date.replaceFirst("(\\d{2}:\\d{2}:\\d{2})[:.](\\d{3,4})$", "$1.$2");
                    LocalDateTime localDateTime = LocalDateTime.parse(string, FORMATTER);
                    Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
                    return Date.from(instant);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

