/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import se.prediktera.breeze.common.util.RtDataFormat;

public class RtHdrParser
implements Cloneable {
    private HashMap<String, String> header = new HashMap();

    public RtHdrParser(File file) throws IOException {
        try (BufferedReader bufferedReader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            this.parseHeader(bufferedReader);
        }
    }

    public RtHdrParser(String string) {
        try (BufferedReader bufferedReader = new BufferedReader(new StringReader(string));){
            this.parseHeader(bufferedReader);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected I/O error with StringReader", iOException);
        }
    }

    public RtHdrParser(HashMap<String, String> hashMap) {
        this.header = hashMap;
    }

    public RtHdrParser() {
    }

    private void parseHeader(BufferedReader bufferedReader) throws IOException {
        String string;
        String string2 = null;
        StringBuilder stringBuilder = null;
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            String string3 = string.replace("\r", "").trim();
            if (string3.isEmpty()) continue;
            if (!bl && string3.contains("=")) {
                int n = string3.indexOf(61);
                string2 = string3.substring(0, n).trim();
                String string4 = string3.substring(n + 1).trim();
                if (string4.startsWith("{") && !string4.endsWith("}")) {
                    bl = true;
                    stringBuilder = new StringBuilder();
                    String string5 = RtHdrParser.stripOpenBrace(string4);
                    if (string5.isEmpty()) continue;
                    stringBuilder.append(string5).append('\n');
                    continue;
                }
                if (string4.startsWith("{") && string4.endsWith("}")) {
                    this.addValue(string2, RtHdrParser.stripBraces(string4));
                    string2 = null;
                    continue;
                }
                this.addValue(string2, RtHdrParser.stripQuotes(string4));
                string2 = null;
                continue;
            }
            if (bl) {
                if (string3.endsWith("}")) {
                    bl = false;
                    stringBuilder.append(RtHdrParser.stripCloseBrace(string3));
                    String string6 = RtHdrParser.trimEnd(stringBuilder.toString(), '\n');
                    this.addValue(string2, string6);
                    string2 = null;
                    stringBuilder = null;
                    continue;
                }
                stringBuilder.append(string3).append('\n');
                continue;
            }
            this.addValue(string3, "");
        }
    }

    private static String stripQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1).trim();
        }
        return string;
    }

    private static String stripBraces(String string) {
        return string.substring(1, string.length() - 1).trim();
    }

    private static String stripOpenBrace(String string) {
        return string.substring(1).trim();
    }

    private static String stripCloseBrace(String string) {
        return string.substring(0, string.length() - 1).trim();
    }

    private static String trimEnd(String string, char c) {
        int n;
        for (n = string.length(); n > 0 && string.charAt(n - 1) == c; --n) {
        }
        return string.substring(0, n);
    }

    public void addValue(String string, String string2) {
        String string3 = string.trim().toLowerCase();
        if (!string3.isEmpty()) {
            this.header.put(string3, string2);
        }
    }

    public boolean contains(String string) {
        return this.header.containsKey(string.toLowerCase());
    }

    public String get(String string, String string2) {
        if (this.contains(string)) {
            return this.get(string);
        }
        return string2;
    }

    public String getOrEmpty(String string) {
        return this.get(string, "");
    }

    public String get(String string) {
        return this.header.get(string.toLowerCase());
    }

    public void set(String string, String string2) {
        this.header.put(string, string2);
    }

    public Object getDescription() {
        return this.get("description");
    }

    public HashMap<String, String> getHeader() {
        return this.header;
    }

    public String[] getArray(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            return null;
        }
        return string2.replace("\r\n", "\n").replace("\r", "\n").split("[,\n]+");
    }

    public int getInt(String string) {
        return RtDataFormat.toNumberInt(this.get(string));
    }

    public float getFloat(String string) {
        return RtDataFormat.toNumberFloat(this.get(string));
    }

    public long getLong(String string) {
        return RtDataFormat.toNumberLong(this.get(string));
    }

    public double getValue(String string) {
        return RtDataFormat.toNumber(this.get(string));
    }

    public int[] getIntArray(String string) {
        String[] stringArray = this.getArray(string);
        if (stringArray != null) {
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = RtDataFormat.toNumberInt(stringArray[i]);
            }
            return nArray;
        }
        return null;
    }

    public float[] getFloatArray(String string) {
        String[] stringArray = this.getArray(string);
        if (stringArray != null) {
            float[] fArray = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fArray[i] = RtDataFormat.toNumberFloat(stringArray[i]);
            }
            return fArray;
        }
        return null;
    }

    public RtHdrParser clone() {
        return new RtHdrParser((HashMap)this.header.clone());
    }
}

