/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.raw;

import se.prediktera.breeze.common.util.RtDataFormat;

public class RtReferenceTarget {
    private final float[] values;

    public RtReferenceTarget(float[] fArray) {
        this.values = fArray;
    }

    public float[] getValues() {
        return this.values;
    }

    public float[] getValuesInv() {
        float[] fArray = new float[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            fArray[i] = 1.0f / this.values[i];
        }
        return fArray;
    }

    public String getAverage() {
        if (this.values.length > 0) {
            float f = 0.0f;
            for (int i = 0; i < this.values.length; ++i) {
                f += this.values[i];
            }
            return RtDataFormat.toString(f / (float)this.values.length);
        }
        return null;
    }

    public String toEnviHdrString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("reference target = {\r\n");
        for (int i = 0; i < this.values.length; ++i) {
            stringBuilder.append(this.values[i]);
            if (i < this.values.length - 1) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\r\n");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static RtReferenceTarget fromHdr(float[] fArray) {
        if (fArray != null) {
            return new RtReferenceTarget(fArray);
        }
        return null;
    }
}

