/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.stream;

import java.io.IOException;
import java.io.OutputStream;
import se.prediktera.breeze.common.util.BreezeProgress;

public class ProgressOutputStream
extends OutputStream {
    private int completed;
    private final OutputStream underlying;
    private BreezeProgress pManager;

    public ProgressOutputStream(OutputStream outputStream) {
        this.underlying = outputStream;
        this.completed = 0;
    }

    public ProgressOutputStream(OutputStream outputStream, BreezeProgress breezeProgress) {
        this(outputStream);
        this.pManager = breezeProgress;
    }

    public void setListener(BreezeProgress breezeProgress) {
        this.pManager = breezeProgress;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.underlying.write(byArray, n, n2);
        this.track(n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.underlying.write(byArray);
        this.track(byArray.length);
    }

    @Override
    public void write(int n) throws IOException {
        this.underlying.write(n);
        this.track(1);
    }

    @Override
    public void flush() throws IOException {
        this.underlying.flush();
    }

    @Override
    public void close() throws IOException {
        this.underlying.close();
    }

    private void track(int n) {
        this.completed += n;
        if (this.pManager != null) {
            this.pManager.incStep(this.completed);
        }
    }
}

