/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.test.asserts;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import se.prediktera.breeze.common.util.test.asserts.AssertFile;

public class AssertDirectory {
    public static void assertDirectoriesEqual(Path path, Path path2) {
        try {
            ArrayList<String> arrayList = AssertDirectory.getRelativeFileNamesRecursive(path);
            ArrayList<String> arrayList2 = AssertDirectory.getRelativeFileNamesRecursive(path2);
            arrayList.sort(String::compareTo);
            arrayList2.sort(String::compareTo);
            MatcherAssert.assertThat((Object)arrayList2.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)arrayList.size())));
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = arrayList.get(i);
                String string2 = arrayList2.get(i);
                MatcherAssert.assertThat((Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)string)));
                AssertFile.assertFilesEqual(Paths.get(String.valueOf(path) + "/" + string, new String[0]), Paths.get(String.valueOf(path2) + "/" + string2, new String[0]));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static ArrayList<String> getRelativeFileNamesRecursive(Path path) throws IOException {
        int n = path.toString().length();
        ArrayList<String> arrayList = new ArrayList<String>();
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            List<Path> list = stream.toList();
            for (Path path2 : list) {
                Object object;
                Object object2;
                if (path2.equals(path)) continue;
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    object2 = AssertDirectory.getRelativeFileNamesRecursive(path2);
                    object = ((ArrayList)object2).iterator();
                    while (object.hasNext()) {
                        String string = (String)object.next();
                        arrayList.add(string);
                    }
                    continue;
                }
                object2 = path2.toString();
                object = ((String)object2).substring(n + 1, ((String)object2).length());
                arrayList.add((String)object);
            }
        }
        return arrayList;
    }
}

