/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.test.asserts;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.test.asserts.AssertCloseTo;

public class AssertFrame {
    public static void closeTo(Frame frame, float[][] fArray, int n) {
        for (int i = 0; i < frame.rows.value; ++i) {
            AssertFrame.closeTo(frame, fArray[i], n, i, 0.01);
        }
    }

    public static void closeTo(Frame frame, float[] fArray, int n, int n2, double d) {
        for (int i = 0; i < frame.columns.value; ++i) {
            try {
                AssertCloseTo.assertThatNumberIsCloseTo(frame.getFrameValue(n2, i), fArray[i], d);
                continue;
            }
            catch (AssertionError assertionError) {
                throw new FrameAssertionError(frame, n, n2, fArray, assertionError);
            }
        }
    }

    public static void closeTo(List<Frame> list, float[][] fArray, int n, int n2) {
        AssertFrame.closeTo(list, fArray, n, n2, 0.01);
    }

    public static void closeTo(List<Frame> list, float[][] fArray, int n, int n2, double d) {
        try {
            int n3 = n;
            int n4 = 0;
            while (n3 < list.size()) {
                AssertFrame.closeTo(list.get(n3), fArray[n4 % fArray.length], n3, n2, d);
                ++n3;
                ++n4;
            }
        }
        catch (AssertionError assertionError) {
            System.out.println("AssertionError: " + ((Throwable)((Object)assertionError)).getMessage());
            System.out.println("StartPos: " + n);
            for (int i = 0; i < list.size(); ++i) {
                System.out.println(String.format("Line: %d\tactual: %s, expected: %s", i, FrameAssertionError.frameToString(list.get(i), 0), FrameAssertionError.arrayToString(fArray[i % fArray.length])));
            }
            throw assertionError;
        }
    }

    public static void closeTo(List<Frame> list, float[][][] fArray, int n, int n2, int n3, double d) {
        try {
            int n4 = n2;
            int n5 = 0;
            while (n4 < list.size()) {
                AssertFrame.closeTo(list.get(n4), fArray[n5 % fArray.length][n], n4, n3, d);
                ++n4;
                ++n5;
            }
        }
        catch (AssertionError assertionError) {
            System.out.println("AssertionError: " + ((Throwable)((Object)assertionError)).getMessage());
            System.out.println("StartPos: " + n2);
            for (int i = 0; i < list.size(); ++i) {
                System.out.println(String.format("Line: %d\tactual: %s, expected: %s", i, FrameAssertionError.frameToString(list.get(i), 0), FrameAssertionError.arrayToString(fArray[i % fArray.length][n])));
            }
            throw assertionError;
        }
    }

    public static int findPos(List<Frame> list, float[] fArray, int n) {
        for (int i = n; i < list.size(); ++i) {
            if (!AssertFrame.frameEquals(fArray, list.get(i))) continue;
            return i - n;
        }
        return 0;
    }

    private static boolean frameEquals(float[] fArray, Frame frame) {
        for (int i = 0; i < fArray.length; ++i) {
            if (frame.getFrameValue(0, i) == fArray[i]) continue;
            return false;
        }
        return true;
    }

    public static void closeTo(List<RawFrame> list, List<RawFrame> list2) {
        AssertFrame.closeTo(list, list2, 0.001);
    }

    public static void closeTo(List<RawFrame> list, List<RawFrame> list2, double d) {
        MatcherAssert.assertThat((String)"Should have same number of frames", (Object)list.size(), (Matcher)Matchers.is((Object)list2.size()));
        for (int i = 0; i < list.size(); ++i) {
            RawFrame rawFrame = list.get(i);
            RawFrame rawFrame2 = list2.get(i);
            for (int j = 0; j < rawFrame.columns.value; ++j) {
                for (int k = 0; k < rawFrame.rows.value; ++k) {
                    AssertCloseTo.assertThatNumberIsCloseTo("f: " + i + ", p: " + j + ", w: " + k, rawFrame.getFrameValue(k, j), rawFrame2.getFrameValue(k, j), d);
                }
            }
        }
    }

    public static class FrameAssertionError
    extends AssertionError {
        public FrameAssertionError(Frame frame, int n, int n2, float[] fArray, AssertionError assertionError) {
            super(String.format("Frame (line %d, band %d) is not close, actual: %s, expected: %s", n, n2, FrameAssertionError.frameToString(frame, n2), FrameAssertionError.arrayToString(fArray)), (Throwable)((Object)assertionError));
        }

        public static String frameToString(Frame frame, int n) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < frame.columns.value; ++i) {
                arrayList.add(RtDataFormat.toString(frame.getFrameValue(n, i)));
            }
            return String.join((CharSequence)", ", arrayList);
        }

        public static String arrayToString(float[] fArray) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (float f : fArray) {
                arrayList.add(RtDataFormat.toString(f));
            }
            return String.join((CharSequence)", ", arrayList);
        }
    }
}

