/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.test.asserts;

import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.util.test.asserts.AssertCloseTo;

public class AssertMatrix {
    public static void assertThatMatrixEquals(double[] dArray, double[] dArray2, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            AssertCloseTo.assertThatNumberIsCloseTo("" + i, dArray[i], dArray2[i], d);
        }
    }

    public static void assertThatMatrixEquals(float[] fArray, float[][] fArray2) {
        AssertMatrix.assertThatMatrixEquals(new FloatMatrix(fArray), new FloatMatrix(fArray2));
    }

    public static void assertThatMatrixEquals(float[][] fArray, float[][] fArray2) {
        AssertMatrix.assertThatMatrixEquals(new FloatMatrix(fArray), new FloatMatrix(fArray2));
    }

    public static void assertThatMatrixEquals(float[][] fArray, float[][] fArray2, double d) {
        AssertMatrix.assertThatMatrixEquals(new FloatMatrix(fArray), new FloatMatrix(fArray2), d);
    }

    public static void assertThatMatrixEquals(float[] fArray, float[] fArray2, double d) {
        AssertMatrix.assertThatMatrixEquals(new FloatMatrix(fArray), new FloatMatrix(fArray2), d);
    }

    public static void assertThatMatrixEquals(FloatMatrix floatMatrix, float[][] fArray) {
        AssertMatrix.assertThatMatrixEquals(floatMatrix, new FloatMatrix(fArray));
    }

    public static void assertThatMatrixEquals(FloatMatrix floatMatrix, FloatMatrix floatMatrix2) {
        AssertMatrix.assertThatMatrixEquals(floatMatrix, floatMatrix2, 1.0E-5);
    }

    public static void assertThatMatrixEquals(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, double d) {
        for (int i = 0; i < floatMatrix.getColumns(); ++i) {
            for (int j = 0; j < floatMatrix.getRows(); ++j) {
                AssertCloseTo.assertThatNumberIsCloseTo(i + "," + j, floatMatrix.get(j, i), floatMatrix2.get(j, i), d);
            }
        }
    }

    public static void assertThatMatrixEquals(Frame frame, FloatMatrix floatMatrix) {
        AssertMatrix.assertThatMatrixEquals(frame, floatMatrix, 1.0E-4);
    }

    public static void assertThatMatrixEquals(Frame frame, FloatMatrix floatMatrix, double d) {
        for (int i = 0; i < frame.getColumns().value; ++i) {
            for (int j = 0; j < frame.getRows().value; ++j) {
                AssertCloseTo.assertThatNumberIsCloseTo("p=" + i + ",w=" + j, frame.getFrameValue(j, i), floatMatrix.get(j, i), d);
            }
        }
    }
}

