/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.test.asserts;

import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import se.prediktera.breeze.common.util.StringFromFile;

public class AssertXml {
    public static void assertValidXmlFile(File file) {
        NodeList nodeList = AssertXml.parseXML(new StringFromFile(file).read());
        MatcherAssert.assertThat((String)("root xml node was parsed for xmlFile: " + String.valueOf(file)), (Object)nodeList, (Matcher)CoreMatchers.notNullValue());
    }

    public static void assertXpathAttributeEquals(File file, String string, String string2) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            NodeList nodeList = (NodeList)xPath.evaluate(string, new InputSource(fileInputStream), XPathConstants.NODESET);
            MatcherAssert.assertThat((String)("value at " + string + " in file " + String.valueOf(file) + " is equal to input"), (Object)nodeList, (Matcher)CoreMatchers.equalTo((Object)string2));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static List<String> assertXmlFilesChildCountEqualAndReturnDiffs(File file, File file2) {
        return AssertXml.assertXmlChildCountEqualAndReturnDiffs(new StringFromFile(file).read(), new StringFromFile(file2).read());
    }

    public static List<String> assertXmlChildCountEqualAndReturnDiffs(String string, String string2) {
        NodeList nodeList = AssertXml.parseXML(string);
        NodeList nodeList2 = AssertXml.parseXML(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        AssertXml.removeEmptyText(nodeList.item(0));
        AssertXml.removeEmptyText(nodeList2.item(0));
        AssertXml.assertXMLRecursive(arrayList, nodeList.item(0), nodeList2.item(0));
        return arrayList;
    }

    public static List<String> assertXmlChildCountEqualAndReturnDiffs(Node node, Node node2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        AssertXml.removeEmptyText(node);
        AssertXml.removeEmptyText(node2);
        AssertXml.assertXMLRecursive(arrayList, node, node2);
        return arrayList;
    }

    private static void assertXMLRecursive(List<String> list, Node node, Node node2) {
        Object object;
        AssertXml.compareNode(list, node, node2);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            object = node2.getAttributes();
            MatcherAssert.assertThat((String)("Node attribute length should be equal: " + node.getNodeName()), (Object)namedNodeMap.getLength(), (Matcher)CoreMatchers.is((Object)object.getLength()));
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                AssertXml.compareNode(list, namedNodeMap.item(i), object.item(i));
            }
        }
        object = node.getChildNodes();
        NodeList nodeList = node2.getChildNodes();
        MatcherAssert.assertThat((String)("Node child length should be equal: " + node.getNodeName()), (Object)object.getLength(), (Matcher)CoreMatchers.is((Object)nodeList.getLength()));
        for (int i = 0; i < object.getLength(); ++i) {
            Node node3 = object.item(i);
            Node node4 = nodeList.item(i);
            AssertXml.assertXMLRecursive(list, node3, node4);
        }
    }

    private static void compareNode(List<String> list, Node node, Node node2) {
        if (node.getNodeType() != 3 && node.getNodeValue() != null && !node.getNodeValue().equals(node2.getNodeValue())) {
            list.add(node.getNodeName());
        }
    }

    private static NodeList parseXML(String string) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            return (NodeList)xPath.evaluate("/", new InputSource(new StringReader(string)), XPathConstants.NODESET);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void removeEmptyText(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNextSibling();
            if (node2.getNodeType() == 3) {
                if (node2.getTextContent().trim().isEmpty()) {
                    node.removeChild(node2);
                }
            } else {
                AssertXml.removeEmptyText(node2);
            }
            node2 = node3;
        }
    }
}

