/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.thread;

import se.prediktera.breeze.common.util.thread.BreezeThread;

public class ExceptionHandlingThread {
    private final BreezeThread thread;
    private final ThreadExceptionCallback onExceptionCallback;
    Exception lastExceptionInThread = null;

    public ExceptionHandlingThread(String string, Runnable runnable, ThreadExceptionCallback threadExceptionCallback) {
        this.thread = new BreezeThread(string, () -> this.run(runnable));
        this.onExceptionCallback = threadExceptionCallback;
    }

    public ExceptionHandlingThread(String string, Runnable runnable) {
        this(string, runnable, runtimeException -> false);
    }

    private void run(Runnable runnable) {
        block2: {
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                if (this.onExceptionCallback.onException(runtimeException)) break block2;
                this.lastExceptionInThread = runtimeException;
            }
        }
    }

    public void start() {
        this.thread.start();
    }

    public boolean isAlive() {
        return this.thread.isAlive();
    }

    public void joinOrThrow() throws ExceptionHandlingThreadException {
        if (this.thread == Thread.currentThread()) {
            return;
        }
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            this.throwIfExceptionHasOccurred();
        }
    }

    public void throwIfExceptionHasOccurred() {
        if (this.lastExceptionInThread != null) {
            Exception exception = this.lastExceptionInThread;
            this.lastExceptionInThread = null;
            throw new ExceptionHandlingThreadException(exception);
        }
    }

    public ThreadExceptionCallback getOnExceptionCallback() {
        return this.onExceptionCallback;
    }

    public static interface ThreadExceptionCallback {
        public boolean onException(RuntimeException var1);
    }

    public static class ExceptionHandlingThreadException
    extends RuntimeException {
        public ExceptionHandlingThreadException(Exception exception) {
            super("Exception occured in thread: " + exception.getMessage(), exception);
        }

        public boolean hasCause(Class<? extends Throwable> clazz) {
            for (Throwable throwable = this.getCause(); throwable != null; throwable = throwable.getCause()) {
                if (!clazz.isInstance(throwable)) continue;
                return true;
            }
            return false;
        }

        public boolean hasCause(Class<? extends Throwable> clazz, String string) {
            for (Throwable throwable = this.getCause(); throwable != null; throwable = throwable.getCause()) {
                if (!clazz.isInstance(throwable) || !string.equals(throwable.getMessage())) continue;
                return true;
            }
            return false;
        }
    }
}

