/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.thread;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.BreezeThread;

public class ThreadUtil {
    public static final Time.MilliSeconds DefaultSleepInterval = new Time.MilliSeconds(10L);

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void sleep(Time time) {
        try {
            Thread.sleep(time.ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void sleep(long l, int n) {
        try {
            Thread.sleep(l, n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void sleepForever() {
        try {
            while (true) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static void wait(Object object) {
        try {
            object.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void wait(Object object, long l) {
        try {
            object.wait(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void join(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void invokeInAfterTimeoutMs(final SimpleCallback simpleCallback, long l) {
        if (l > 0L) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    simpleCallback.callback();
                }
            }, l);
        } else {
            simpleCallback.callback();
        }
    }

    public static Thread runAfterConditionIsMet(final StateCallback stateCallback, final SimpleCallback simpleCallback, final Time time) {
        BreezeThread breezeThread = new BreezeThread("ConditionThread"){

            @Override
            public void run() {
                if (ThreadUtil.awaitAndReturn(stateCallback, time, Time.Forever)) {
                    simpleCallback.callback();
                }
            }
        };
        breezeThread.start();
        return breezeThread;
    }

    public static void runAfterConditionIsMet(RunAfterConditionIsMetCallback runAfterConditionIsMetCallback) {
        ThreadUtil.runAfterConditionIsMet(runAfterConditionIsMetCallback::conditionIsMet, runAfterConditionIsMetCallback::actionToRun, new Time.MilliSeconds(10L));
    }

    public static void awaitOrThrow(StateCallback stateCallback) {
        ThreadUtil.awaitOrThrow(stateCallback, Time.Forever);
    }

    public static void awaitOrThrow(StateCallback stateCallback, Time time) {
        ThreadUtil.awaitOrThrow(stateCallback, DefaultSleepInterval, time, "timeout waiting for state callback to become true");
    }

    public static void awaitOrThrow(StateCallback stateCallback, Time time, String string) {
        ThreadUtil.awaitOrThrow(stateCallback, DefaultSleepInterval, time, string);
    }

    public static void awaitOrThrow(StateCallback stateCallback, Time time, Time time2, String string) {
        if (!ThreadUtil.awaitAndReturn(stateCallback, time, time2) && time2 != Time.Forever) {
            throw new TimeoutException(string);
        }
    }

    public static void awaitOrThrow(StateCallback stateCallback, Time time, int n, Time time2, String string) {
        ThreadUtil.sleep(n);
        ThreadUtil.awaitOrThrow(stateCallback, time, time2, string);
    }

    public static boolean awaitAndReturn(StateCallback stateCallback, Time time) {
        return ThreadUtil.awaitAndReturn(stateCallback, DefaultSleepInterval, time);
    }

    public static boolean awaitAndReturn(StateCallback stateCallback, Time time, Time time2) {
        long l = System.currentTimeMillis();
        RateKeeper rateKeeper = new RateKeeper(time.toFps());
        while (System.currentTimeMillis() - l < time2.ms && !Thread.currentThread().isInterrupted()) {
            if (stateCallback.isInState()) {
                return true;
            }
            rateKeeper.waitIfNeeded();
        }
        return false;
    }

    public static interface SimpleCallback {
        public void callback();
    }

    public static interface StateCallback {
        public boolean isInState();
    }

    public static interface RunAfterConditionIsMetCallback {
        public boolean conditionIsMet();

        public void actionToRun();
    }

    public static class TimeoutException
    extends RuntimeException {
        public TimeoutException(String string) {
            super(string);
        }
    }

    public static class RateKeeper {
        private static final long ONE_HOUR_IN_NANOS = TimeUnit.HOURS.toNanos(1L);
        private float desiredFrequency;
        private long desiredFrameTimeNanos;
        private boolean firstCall = true;
        private long totalFrameTimeNanos;
        private long startTimeNanos;

        public RateKeeper(float f) {
            this.updateFrameRate(f);
        }

        public void updateFrameRate(float f) {
            this.desiredFrequency = f;
            this.desiredFrameTimeNanos = TimeUnit.SECONDS.toNanos(1L) / (long)f;
        }

        public float fps() {
            return this.desiredFrequency;
        }

        public void reset() {
            this.firstCall = true;
        }

        public void waitIfNeeded() {
            long l;
            long l2 = System.nanoTime();
            if (l2 - this.startTimeNanos > this.totalFrameTimeNanos + 5L * this.desiredFrameTimeNanos) {
                this.firstCall = true;
            }
            if (this.firstCall) {
                this.totalFrameTimeNanos = 0L;
                this.startTimeNanos = l2;
                this.firstCall = false;
            }
            this.totalFrameTimeNanos += this.desiredFrameTimeNanos;
            while ((l = this.totalFrameTimeNanos - (System.nanoTime() - this.startTimeNanos)) > 0L) {
                if (l > 1000000L) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                Thread.yield();
            }
            if (this.totalFrameTimeNanos > ONE_HOUR_IN_NANOS) {
                this.reset();
            }
        }
    }

    public static class FloatSleep {
        float sleepTime;
        float accumulatedSleepTime = 0.0f;

        public FloatSleep(float f) {
            this.sleepTime = f;
        }

        public void sleep() {
            this.accumulatedSleepTime += this.sleepTime;
            int n = (int)this.accumulatedSleepTime;
            ThreadUtil.sleep(n);
            this.accumulatedSleepTime -= (float)n;
        }
    }
}

