/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.thread;

import org.junit.Assert;
import org.junit.Test;
import se.prediktera.breeze.common.util.performance.MeasuredFps;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.common.util.type.FrameRate;

public class ThreadUtilTest {
    @Test
    public void testRateKeeper() {
        for (int n : new int[]{50, 100, 250, 500, 750, 1000, 1250, 1500, 1750, 3000}) {
            int n2 = n / 4;
            FrameRate frameRate = this.TestFrameRate(n, n2).getActual();
            float f = Math.abs(frameRate.value - (float)n);
            float f2 = (float)n * 0.25f;
            Assert.assertTrue((String)("RateKeeper FrameRate=" + n + ", ActualFps=" + String.valueOf(frameRate) + ", diff=" + f + ", maxdiff=" + f2 + ", times=" + n2), (f < f2 ? 1 : 0) != 0);
        }
    }

    private MeasuredFps TestFrameRate(float f, int n) {
        ThreadUtil.RateKeeper rateKeeper = new ThreadUtil.RateKeeper(f);
        MeasuredFps measuredFps = new MeasuredFps();
        for (int i = 0; i < n; ++i) {
            measuredFps.increase();
            rateKeeper.waitIfNeeded();
        }
        return measuredFps;
    }
}

